/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Consumes;
import org.ow2.petals.jbi.descriptor.original.generated.Identification;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.Provides;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.descriptor.original.generated.Target;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractConfigurableMojo;
import org.ow2.petals.plugin.jbiplugin.util.PropertiesInterpolationValueSource;
import org.ow2.petals.plugin.jbiplugin.util.ZipUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JBIPackageMojo
extends JBIAbstractConfigurableMojo {
    protected File artifactJar;
    protected File additionalJBIResourceDirectory;
    protected boolean updateJBIXml;
    protected String serviceUnitFileNameMappingInSA;
    protected String serviceUnitNameMappingInSA;
    protected String serviceAssemblyNameMapping;
    protected String componentNameMapping;
    protected String sharedLibraryNameMapping;
    protected String toExcludes;
    private Set<String> entries = new HashSet<String>();
    private Set<String> entriesToExclude = new HashSet<String>();

    private void recurseDirectory(ZipOutputStream zipOutputStream, File directory, String entryDirectoryName) throws IOException {
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                if (this.updateJBIXml && "jbi.xml".equals(file.getName())) continue;
                this.info("     " + file.getName() + " added to JBI archive");
                if (file.getName().equals("jbi.xml")) {
                    ZipUtil.addFile(zipOutputStream, new FileInputStream(file), (entryDirectoryName.equals("") ? "" : entryDirectoryName + "/") + "META-INF/" + file.getName());
                    continue;
                }
                ZipUtil.addFile(zipOutputStream, new FileInputStream(file), (entryDirectoryName.equals("") ? "" : entryDirectoryName + "/") + file.getName());
                continue;
            }
            this.debug("File entry: " + file.getName());
            if (file.getName().startsWith(".") || file.getName().toUpperCase(Locale.getDefault()).equals("CVS")) continue;
            this.recurseDirectory(zipOutputStream, file, (entryDirectoryName.equals("") ? "" : entryDirectoryName + "/") + file.getName());
        }
    }

    private void extractExcludeValues() {
        if (!"foo".equalsIgnoreCase(this.toExcludes)) {
            this.toExcludes = this.toExcludes.replace(" ", "");
            for (String jar : this.toExcludes.split(",")) {
                this.entriesToExclude.add(jar);
            }
        }
    }

    @Override
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        this.debug("Configuration mode: " + (this.includeConfiguration ? "activated" : "unactivated"));
        if (this.includeConfiguration) {
            this.readConfigurationFiles();
        }
        this.attachedJBIArchive(this.project.getArtifact());
        this.extractExcludeValues();
        if (this.outputDirectory.exists()) {
            if (this.projectArtifact.getFile().exists()) {
                this.projectArtifact.getFile().delete();
            }
        } else {
            this.outputDirectory.mkdirs();
        }
        if (this.jbiDirectory.exists()) {
            if ("jbi-component".equals(this.project.getPackaging())) {
                this.packageComponent();
            } else if ("jbi-service-unit".equals(this.project.getPackaging())) {
                this.packageServiceUnit();
            } else if ("jbi-service-assembly".equals(this.project.getPackaging())) {
                this.packageServiceAssembly();
            } else if ("jbi-shared-library".equals(this.project.getPackaging())) {
                this.packageSharedLibrary();
            }
        } else {
            this.error("JBI directory [" + this.jbiDirectory + "] does not exist.");
            throw new MojoFailureException("JBI directory [" + this.jbiDirectory + "] does not exist.");
        }
    }

    private void packageComponent() throws MojoExecutionException {
        try {
            this.info("Start building JBI component archive " + this.projectArtifact.getFile().getAbsolutePath());
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.projectArtifact.getFile()));
            this.recurseDirectory(zipOutputStream, this.jbiDirectory, "");
            zipOutputStream.flush();
            this.addArtifactResources(zipOutputStream);
            this.addDependencies(zipOutputStream);
            this.addJBIResources(zipOutputStream);
            if (this.updateJBIXml) {
                this.updateComponentJBIXmlFile(zipOutputStream);
            }
            zipOutputStream.flush();
            zipOutputStream.close();
            this.info("JBI component archive building done.");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void packageServiceUnit() throws MojoExecutionException {
        try {
            this.info("Start building JBI service-unit archive " + this.project.getArtifact().getFile().getAbsolutePath());
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.project.getArtifact().getFile()));
            try {
                FileInputStream jbiDescriptorToUpdateInputStream = new FileInputStream(this.jbiDirectory + File.separator + "jbi.xml");
                Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiDescriptorToUpdateInputStream);
                if (jbiDescriptor == null) {
                    throw new MojoExecutionException("JBI Descriptor is null");
                }
                if (this.updateJBIXml) {
                    List nodeList;
                    for (Consumes consumes : jbiDescriptor.getServices().getConsumes()) {
                        nodeList = consumes.getAnyOrAny();
                        this.evaluateElementList(nodeList);
                    }
                    for (Provides provides : jbiDescriptor.getServices().getProvides()) {
                        nodeList = provides.getAnyOrAny();
                        this.evaluateElementList(nodeList);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    JBIDescriptorBuilder.writeJBIdescriptor((Jbi)jbiDescriptor, (OutputStream)baos);
                    this.debug("Generated JBI Descriptor:\n" + baos.toString());
                    ByteArrayInputStream jbiDescriptorInputStream = new ByteArrayInputStream(baos.toByteArray());
                    ZipUtil.addFile(zipOutputStream, jbiDescriptorInputStream, "META-INF/jbi.xml");
                    this.info("\tJBI descriptor added to JBI Service Unit archive");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
            }
            catch (JBIDescriptorException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
            catch (Throwable e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), e);
            }
            this.recurseDirectory(zipOutputStream, this.jbiDirectory, "");
            zipOutputStream.flush();
            this.addArtifactResources(zipOutputStream);
            this.addDependencies(zipOutputStream);
            this.addJBIResources(zipOutputStream);
            zipOutputStream.close();
            this.info("JBI Service unit archive building done.");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void packageServiceAssembly() throws MojoExecutionException {
        this.info("Start building JBI service-assembly archive " + this.project.getArtifact().getFile().getAbsolutePath());
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.project.getArtifact().getFile()));
            try {
                InputStream jbiDescriptorInputStream;
                FileInputStream jbiDescriptorToUpdateInputStream = new FileInputStream(this.jbiDirectory + File.separator + "jbi.xml");
                Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiDescriptorToUpdateInputStream);
                if (jbiDescriptor == null) {
                    throw new MojoExecutionException("JBI Descriptor is null");
                }
                if (this.updateJBIXml) {
                    if (jbiDescriptor.getServiceAssembly() == null) {
                        throw new MojoExecutionException("No service-assembly in the JBI descriptor.");
                    }
                    if (jbiDescriptor.getServiceAssembly().getIdentification() == null) {
                        throw new MojoExecutionException("No identification in the JBI descriptor.");
                    }
                    String artifactName = this.evaluateJBIIdentifier(this.serviceAssemblyNameMapping, this.project.getArtifact());
                    jbiDescriptor.getServiceAssembly().getIdentification().setName(artifactName);
                    jbiDescriptor.getServiceAssembly().getIdentification().setDescription(this.project.getDescription());
                    jbiDescriptor.getServiceAssembly().getServiceUnit().clear();
                }
                List dependencies = this.project.getDependencies();
                for (Dependency dependency : dependencies) {
                    if (!"jbi-service-unit".equals(dependency.getType())) continue;
                    Artifact serviceUnitArtifact = this.createDependencyArtifact(dependency);
                    this.artifactResolver.resolve(serviceUnitArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    MavenProject serviceUnitProject = this.mavenProjectBuilder.buildFromRepository(serviceUnitArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    String zipDependencyFileName = serviceUnitArtifact.getFile().getName();
                    if (this.updateJBIXml) {
                        ServiceUnit serviceUnit = new ServiceUnit();
                        Identification identification = new Identification();
                        identification.setName(this.evaluateJBIIdentifier(this.serviceUnitNameMappingInSA, serviceUnitProject.getArtifact()));
                        identification.setDescription(serviceUnitProject.getDescription());
                        serviceUnit.setIdentification(identification);
                        Jbi jbiComponentDescriptor = null;
                        Artifact serviceUnitComponentArtifact = null;
                        boolean foundInServiceUnitDependencies = false;
                        List serviceUnitDependencies = serviceUnitProject.getDependencies();
                        for (Dependency serviceUnitDependency : serviceUnitDependencies) {
                            this.debug("SU dependency: " + serviceUnitDependency);
                            if (!"jbi-component".equals(serviceUnitDependency.getType())) continue;
                            this.debug("Component dependency found: " + serviceUnitDependency);
                            foundInServiceUnitDependencies = true;
                            try {
                                serviceUnitComponentArtifact = this.createDependencyArtifact(serviceUnitDependency);
                                this.artifactResolver.resolve(serviceUnitComponentArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                                jbiComponentDescriptor = this.readJbiDescriptor(serviceUnitComponentArtifact);
                                this.debug("Component found: " + serviceUnitComponentArtifact);
                                break;
                            }
                            catch (InvalidVersionSpecificationException e) {
                                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
                            }
                            catch (ArtifactResolutionException e) {
                                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
                            }
                            catch (ArtifactNotFoundException e) {
                                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
                            }
                        }
                        if (!foundInServiceUnitDependencies) {
                            throw new MojoExecutionException("No component defined in SU as dependency.");
                        }
                        this.debug("Component name: " + jbiComponentDescriptor.getComponent().getIdentification().getName());
                        Target target = new Target();
                        target.setComponentName(this.evaluateJBIIdentifier(jbiComponentDescriptor.getComponent().getIdentification().getName(), serviceUnitComponentArtifact));
                        target.setArtifactsZip(zipDependencyFileName);
                        serviceUnit.setTarget(target);
                        jbiDescriptor.getServiceAssembly().getServiceUnit().add(serviceUnit);
                    }
                    this.debug("SU artifact file: " + serviceUnitArtifact.getFile());
                    ZipUtil.addFile(zipOutputStream, new FileInputStream(serviceUnitArtifact.getFile()), zipDependencyFileName);
                    this.info("\t" + serviceUnitArtifact.getFile().getName() + " added to JBI Service Assembly archive (as " + zipDependencyFileName + ")");
                }
                if (this.updateJBIXml) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    JBIDescriptorBuilder.writeJBIdescriptor((Jbi)jbiDescriptor, (OutputStream)baos);
                    this.debug("Generated JBI Descriptor:\n" + baos.toString());
                    jbiDescriptorInputStream = new ByteArrayInputStream(baos.toByteArray());
                } else {
                    jbiDescriptorInputStream = new FileInputStream(this.jbiDirectory + File.separator + "jbi.xml");
                }
                ZipUtil.addFile(zipOutputStream, jbiDescriptorInputStream, "META-INF/jbi.xml");
                this.info("\tJBI descriptor added to JBI Service Assembly archive");
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
            }
            catch (JBIDescriptorException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
            catch (Throwable e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), e);
            }
            finally {
                try {
                    zipOutputStream.close();
                }
                catch (ZipException e) {
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
                }
            }
            this.info("JBI Service Assembly archive building done.");
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void packageSharedLibrary() throws MojoExecutionException {
        try {
            this.info("Start building JBI shared-library archive " + this.project.getArtifact().getFile().getAbsolutePath());
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.project.getArtifact().getFile()));
            this.recurseDirectory(zipOutputStream, this.jbiDirectory, "");
            zipOutputStream.flush();
            this.addArtifactResources(zipOutputStream);
            this.addDependencies(zipOutputStream);
            this.addJBIResources(zipOutputStream);
            if (this.updateJBIXml) {
                this.updateSharedLibraryJBIXmlFile(zipOutputStream);
            }
            zipOutputStream.close();
            this.info("JBI Shared library archive building done.");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void addJBIResources(ZipOutputStream zipOutputStream) throws IOException {
        if (this.additionalJBIResourceDirectory != null && this.additionalJBIResourceDirectory.isDirectory()) {
            File[] additionnalJBIFiles;
            for (File additionnalJBIFile : additionnalJBIFiles = this.additionalJBIResourceDirectory.listFiles()) {
                if (additionnalJBIFile.isFile()) {
                    this.zipFile(zipOutputStream, additionnalJBIFile);
                    this.info("Additional JBI resource [" + additionnalJBIFile + "] has been added to packaging as a file.");
                    continue;
                }
                this.zipDirectory(zipOutputStream, additionnalJBIFile, "");
                this.info("Additional JBI resource [" + additionnalJBIFile + "] has been added to packaging as a directory.");
            }
        }
    }

    private void zipDirectory(ZipOutputStream zipOutputStream, File file, String hierarchyPath) {
        try {
            ZipUtil.addDirectory(zipOutputStream, hierarchyPath + "/" + file.getName());
            this.info("\t" + file.getName() + " directory added to JBI archive");
            for (File subFile : file.listFiles()) {
                if (subFile.isFile()) {
                    this.zipFileInDirectory(zipOutputStream, subFile, hierarchyPath + "/" + file.getName());
                    this.info("Additional JBI resource [" + subFile + "] has been added to packaging as a file.");
                    continue;
                }
                this.zipDirectory(zipOutputStream, subFile, hierarchyPath + "/" + file.getName());
                this.info("Additional JBI resource [" + subFile + "] has been added to packaging as a directory.");
            }
        }
        catch (IOException e) {
            this.entriesToExclude.add(file.getName());
            this.error("Problem while adding " + file.getName() + " directory to JBI archive", e);
        }
    }

    private void zipFileInDirectory(ZipOutputStream zipOutputStream, File subFile, String hierarchyPath) {
        try {
            ZipUtil.addFile(zipOutputStream, new FileInputStream(subFile), hierarchyPath + "/" + subFile.getName());
            this.info("\t" + subFile.getName() + " directory added to JBI archive");
        }
        catch (IOException e) {
            this.entriesToExclude.add(subFile.getName());
            this.error("Problem while adding " + subFile.getName() + " directory to JBI archive", e);
        }
    }

    private void addArtifactResources(ZipOutputStream zipOutputStream) throws IOException {
        if (this.artifactJar.exists()) {
            this.entries.add(this.artifactJar.getName());
            this.zipFile(zipOutputStream, this.artifactJar);
        }
    }

    private void addDependencies(ZipOutputStream zipOutputStream) throws IOException, MojoExecutionException {
        HashSet<Artifact> wholeArtifactsSet = new HashSet<Artifact>();
        wholeArtifactsSet.addAll(this.project.getArtifacts());
        for (Artifact artifact : wholeArtifactsSet) {
            if (!artifact.getScope().equals("compile") && !artifact.getScope().equals("runtime")) continue;
            this.addArtifact(artifact, wholeArtifactsSet, zipOutputStream, new ArrayList<Exclusion>());
        }
    }

    private void addArtifact(Artifact dependencyArtifact, Set<Artifact> wholeArtifactFiles, ZipOutputStream zipOutputStream, List<Exclusion> parentDependencyExclusions) throws IOException, MojoExecutionException {
        this.entries.add(dependencyArtifact.getFile().getName());
        this.zipFile(zipOutputStream, dependencyArtifact.getFile());
    }

    private Set<String> cloneSet(Set<String> setToClone) {
        HashSet<String> outSet = new HashSet<String>();
        for (String string : setToClone) {
            outSet.add(string);
        }
        return outSet;
    }

    private void updateComponentJBIXmlFile(ZipOutputStream zipOutputStream) throws MojoExecutionException {
        try {
            String entry;
            FileInputStream jbiDescriptorToUpdateInputStream = new FileInputStream(this.jbiDirectory + File.separator + "jbi.xml");
            Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiDescriptorToUpdateInputStream);
            Component component = jbiDescriptor.getComponent();
            String artifactName = this.evaluateJBIIdentifier(this.componentNameMapping, this.project.getArtifact());
            component.getIdentification().setName(artifactName);
            String description = this.project.getDescription();
            if (description != null && description.length() > 0) {
                component.getIdentification().setDescription(description);
            } else {
                this.info("Entry 'description' not updated in the JBI descriptor because it is not set in POM file.");
            }
            Set<String> elemsToAdd = this.cloneSet(this.entries);
            List compoClassPath = component.getComponentClassPath().getPathElement();
            for (String elem : compoClassPath) {
                if (!elemsToAdd.contains(elem)) continue;
                elemsToAdd.remove(elem);
            }
            compoClassPath.addAll(elemsToAdd);
            Iterator itCompoClassPath = compoClassPath.iterator();
            while (itCompoClassPath.hasNext()) {
                entry = (String)itCompoClassPath.next();
                if (entry.trim().length() != 0) continue;
                itCompoClassPath.remove();
            }
            elemsToAdd = this.cloneSet(this.entries);
            List bootClassPath = component.getBootstrapClassPath().getPathElement();
            for (String elem : bootClassPath) {
                if (!elemsToAdd.contains(elem)) continue;
                elemsToAdd.remove(elem);
            }
            bootClassPath.addAll(elemsToAdd);
            Iterator itBootClassPath = bootClassPath.iterator();
            while (itBootClassPath.hasNext()) {
                entry = (String)itBootClassPath.next();
                if (entry.trim().length() != 0) continue;
                itBootClassPath.remove();
            }
            this.info("Update shared libraries.");
            List<Component.SharedLibrary> sharedLibraries = this.evaluateSharedLibraries(this.project.getArtifact());
            component.getSharedLibraryList().clear();
            for (Component.SharedLibrary sharedLibrary : sharedLibraries) {
                component.getSharedLibraryList().add(sharedLibrary);
                this.info("Shared library added: " + sharedLibrary.getContent());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JBIDescriptorBuilder.writeJBIdescriptor((Jbi)jbiDescriptor, (OutputStream)baos);
            ByteArrayInputStream jbiDescriptorInputStream = new ByteArrayInputStream(baos.toByteArray());
            ZipUtil.addFile(zipOutputStream, jbiDescriptorInputStream, "META-INF/jbi.xml");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem while updating jbi.xml file. We add it like it is", e);
        }
    }

    private void updateSharedLibraryJBIXmlFile(ZipOutputStream zipOutputStream) throws MojoExecutionException {
        try {
            FileInputStream jbiDescriptorToUpdateInputStream = new FileInputStream(this.jbiDirectory + File.separator + "jbi.xml");
            Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiDescriptorToUpdateInputStream);
            Jbi.SharedLibrary sharedLibrary = jbiDescriptor.getSharedLibrary();
            String artifactName = this.evaluateJBIIdentifier(this.sharedLibraryNameMapping, this.project.getArtifact());
            sharedLibrary.getIdentification().setName(artifactName);
            sharedLibrary.setVersion(this.evaluateJBIVersion(this.project.getVersion(), this.project.getArtifact()));
            Set<String> elemsToAdd = this.cloneSet(this.entries);
            List slClassPath = sharedLibrary.getSharedLibraryClassPath().getPathElement();
            for (String elem : slClassPath) {
                if (!elemsToAdd.contains(elem)) continue;
                elemsToAdd.remove(elem);
            }
            elemsToAdd.add(this.artifactJar.getName());
            slClassPath.clear();
            slClassPath.addAll(elemsToAdd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JBIDescriptorBuilder.writeJBIdescriptor((Jbi)jbiDescriptor, (OutputStream)baos);
            ByteArrayInputStream jbiDescriptorInputStream = new ByteArrayInputStream(baos.toByteArray());
            ZipUtil.addFile(zipOutputStream, jbiDescriptorInputStream, "META-INF/jbi.xml");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem while updating jbi.xml file. We add it like it is", e);
        }
    }

    private void zipFile(ZipOutputStream zipOutputStream, File file) {
        try {
            ZipUtil.addFile(zipOutputStream, new FileInputStream(file), file.getName());
            this.info("\t" + file.getName() + " file added to JBI archive");
        }
        catch (IOException e) {
            this.entriesToExclude.add(file.getName());
            this.error("Problem while adding " + file.getName() + " file to JBI archive", e);
        }
    }

    private String evaluateFileNameMapping(String expression, Artifact artifact, Properties properties) {
        this.debug("Evaluating expression: " + expression);
        String value = expression.replaceAll("\\$\\{dollarSign\\}", "\\$");
        artifact.isSnapshot();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        if (artifact != null) {
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)artifact));
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)artifact.getArtifactHandler()));
        }
        if (properties != null) {
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)properties));
        }
        Properties classifierMask = new Properties();
        classifierMask.setProperty("classifier", "");
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(classifierMask));
        value = interpolator.interpolate(value, "__artifact");
        this.debug("Expression evaluated to: " + value);
        return value;
    }

    private void evaluateElementList(List<Element> nodeList) throws DOMException {
        for (Element elt : nodeList) {
            this.evaluateNodeList(elt.getChildNodes());
        }
    }

    private void evaluateNodeList(NodeList nodeList) throws DOMException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3 && !nodeList.item(i).getTextContent().trim().equals("")) {
                String mappedText = this.evaluateFileNameMapping(nodeList.item(i).getTextContent(), this.project.getArtifact(), this.project.getProperties());
                nodeList.item(i).setTextContent(mappedText);
                continue;
            }
            if (nodeList.item(i).getChildNodes() == null) continue;
            this.evaluateNodeList(nodeList.item(i).getChildNodes());
        }
    }

    private boolean includeDependencyInPackage(Dependency dependency, boolean isTransitiveDependency) throws MojoExecutionException {
        try {
            String scope = dependency.getScope();
            if (scope != null && ("test".equals(scope) || "provided".equals(scope))) {
                this.debug(dependency.getGroupId() + "-" + dependency.getArtifactId() + "'s scope not required");
                return false;
            }
            if (isTransitiveDependency && dependency.isOptional()) {
                this.debug(dependency.getGroupId() + "-" + dependency.getArtifactId() + " is optional and transitive, so not required");
                return false;
            }
            Artifact dependencyArtifact = this.createDependencyArtifact(dependency);
            this.artifactResolver.resolve(dependencyArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            String artifactName = dependencyArtifact.getFile().getName();
            if (this.entries.contains(artifactName)) {
                this.debug(artifactName + " already marked as required");
                return false;
            }
            if (this.entriesToExclude.contains(artifactName)) {
                this.debug(artifactName + " is marked as excluded");
                return false;
            }
            String type = dependency.getType();
            if (type != null && ("jbi-shared-library".equals(type) || "jbi-component".equals(type))) {
                this.debug(artifactName + "'s type not required");
                return false;
            }
            return true;
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    @Override
    protected MavenProject getMavenProject() {
        return this.project;
    }
}

