#!/bin/sh
#
#                      Petals CLI Bootstrap Script
#
# Environment variables:
#
#	JAVA_HOME		Directory containing the JRE. Use the java executable
#					found in $PATH if not defined.
#
#	JAVA_OPTS		Options for the JVM. Try "java -h" to get informations
#					about the available options for your environment
#
#############################################################################

#Test symbolic link 
if [ -h $0 ];then
	CUR_DIR=$(dirname $(readlink $0))
else
	CUR_DIR=`dirname $0`
fi

# Set the path to the java executable
JAVA="$JAVA_HOME/bin/java"
[ -x "$JAVA" ] || JAVA="`which java`" || {
	echo "ERROR: java executable not found" >&2
	exit 1
}


# Set the path to petals bootstrap jar
PETALS_JAR="${CUR_DIR}/petals-cli.jar"
[ -f "$PETALS_JAR" ] || {
	echo "ERROR: petals-cli.jar: jar archive not found" >&2
	exit 1
}


# Adapt pathes if architecture is Cygwin
case "`uname`" in
	CYGWIN*)
		JAVA="`cygpath --path --dos "$JAVA"`"
		PETALS_HOME="`cygpath --path --dos "$PETALS_HOME"`"
		PETALS_JAR="`cygpath --path --dos "$PETALS_JAR"`"
		;;
esac


exec "$JAVA" $JAVA_OPTS -jar "$PETALS_JAR" "$@"

