/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Identification;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractConfigurableMojo;
import org.ow2.petals.plugin.jbiplugin.util.ZipUtil;

public class JBIConfigureMojo
extends JBIAbstractConfigurableMojo {
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String targetName;
    protected File configuredArtifactOutputDirectory;
    private MavenProject providedProject;

    @Override
    protected boolean packagingIsOkForGoal() {
        return true;
    }

    @Override
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        block8: {
            this.readConfigurationFiles();
            try {
                if (!this.configuredArtifactOutputDirectory.exists()) {
                    this.configuredArtifactOutputDirectory.mkdirs();
                }
                Artifact artifact = this.artifactFactory.createProjectArtifact(this.groupId, this.artifactId, this.version);
                this.providedProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                artifact = this.artifactFactory.createArtifact(this.groupId, this.artifactId, this.version, null, this.providedProject.getPackaging());
                this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                String artifactType = this.providedProject.getPackaging();
                if ("jbi-component".equals(artifactType)) {
                    this.configureComponent(artifact);
                    break block8;
                }
                if ("jbi-service-assembly".equals(artifactType)) {
                    throw new MojoExecutionException("Coming next ...");
                }
                if ("jbi-shared-library".equals(artifactType)) {
                    this.configureSharedLibrary(artifact);
                    break block8;
                }
                throw new MojoExecutionException("Unsupported artifact type: " + artifactType);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("A problem occurs during configuration.", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("A problem occurs during configuration.", (Exception)((Object)e));
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("A problem occurs during configuration.", (Exception)((Object)e));
            }
        }
    }

    private void configureComponent(final Artifact artifact) throws MojoExecutionException {
        try {
            File artifactFile = artifact.getFile();
            this.info("The following file is used as artifact source: " + artifactFile.getAbsolutePath());
            ZipFile zipArtifactFile = new ZipFile(artifactFile);
            String targetComponentName = artifact.getFile().getName();
            if (this.targetName != null) {
                targetComponentName = this.targetName + ".zip";
            }
            File configuredArtifactFile = new File(this.configuredArtifactOutputDirectory, targetComponentName);
            this.debug("Output JBI archive file: " + configuredArtifactFile.getAbsolutePath());
            ZipOutputStream zipConfiguredArtifactFile = new ZipOutputStream(new FileOutputStream(configuredArtifactFile));
            ZipUtil.copyAndUpdateZipFile(zipArtifactFile, zipConfiguredArtifactFile, new ZipUtil.ZipEntryCallback(){
                private final List<Artifact> artifactToAdd = new LinkedList<Artifact>();

                @Override
                public List<Artifact> getExtraEntryToAdd() {
                    return this.artifactToAdd;
                }

                @Override
                public InputStream onZipEntry(ZipEntry zipEntry, InputStream zipEntryInputStream) throws IOException, MojoExecutionException {
                    if ("META-INF/jbi.xml".equals(zipEntry.getName())) {
                        try {
                            Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)zipEntryInputStream);
                            Component component = jbiDescriptor.getComponent();
                            Identification ident = component.getIdentification();
                            ident.setName(JBIConfigureMojo.this.evaluateJBIIdentifier(ident.getName(), artifact));
                            List<Component.SharedLibrary> sharedLibraries = JBIConfigureMojo.this.evaluateSharedLibraries(artifact);
                            component.getSharedLibraryList().clear();
                            for (Component.SharedLibrary sharedLibrary : sharedLibraries) {
                                component.getSharedLibraryList().add(sharedLibrary);
                            }
                            List<Artifact> classpathElts = JBIConfigureMojo.this.evaluateBootstrapClasspathElts(artifact);
                            List existingClasspathElts = jbiDescriptor.getComponent().getBootstrapClassPath().getPathElement();
                            for (Artifact classpathElt : classpathElts) {
                                if (existingClasspathElts.contains(classpathElt)) continue;
                                existingClasspathElts.add(classpathElt.getFile().getName());
                                this.artifactToAdd.add(classpathElt);
                                JBIConfigureMojo.this.debug("Extra file added: " + classpathElt.getFile().getName() + " to the boostrap classpath");
                            }
                            classpathElts = JBIConfigureMojo.this.evaluateComponentClasspathElts(artifact);
                            existingClasspathElts = jbiDescriptor.getComponent().getComponentClassPath().getPathElement();
                            for (Artifact classpathElt : classpathElts) {
                                if (existingClasspathElts.contains(classpathElt.getFile().getName())) continue;
                                existingClasspathElts.add(classpathElt.getFile().getName());
                                this.artifactToAdd.add(classpathElt);
                                JBIConfigureMojo.this.debug("Extra file added: " + classpathElt.getFile().getName() + " to the component classpath");
                            }
                            ByteArrayOutputStream baosUpdatedJbiDesc = new ByteArrayOutputStream();
                            JBIDescriptorBuilder.writeJBIdescriptor((Jbi)jbiDescriptor, (OutputStream)baosUpdatedJbiDesc);
                            zipEntry.setTime(System.currentTimeMillis());
                            return new ByteArrayInputStream(baosUpdatedJbiDesc.toByteArray());
                        }
                        catch (JBIDescriptorException e) {
                            throw new MojoExecutionException("Error reading JBI descriptor.", (Exception)((Object)e));
                        }
                    }
                    return zipEntryInputStream;
                }
            });
            zipConfiguredArtifactFile.flush();
            zipConfiguredArtifactFile.close();
            this.info("The configured JBI archive is available here: " + configuredArtifactFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("A problem occurs during configuration.", (Exception)e);
        }
    }

    private void configureSharedLibrary(final Artifact artifact) throws MojoExecutionException {
        try {
            File artifactFile = artifact.getFile();
            this.info("The following file is used as artifact source: " + artifactFile.getAbsolutePath());
            ZipFile zipArtifactFile = new ZipFile(artifactFile);
            File configuredArtifactFile = new File(this.configuredArtifactOutputDirectory, this.targetName + ".zip");
            this.debug("Output JBI archive file: " + configuredArtifactFile.getAbsolutePath());
            ZipOutputStream zipConfiguredArtifactFile = new ZipOutputStream(new FileOutputStream(configuredArtifactFile));
            ZipUtil.copyAndUpdateZipFile(zipArtifactFile, zipConfiguredArtifactFile, new ZipUtil.ZipEntryCallback(){

                @Override
                public InputStream onZipEntry(ZipEntry zipEntry, InputStream zipEntryInputStream) throws IOException, MojoExecutionException {
                    if ("META-INF/jbi.xml".equals(zipEntry.getName())) {
                        try {
                            Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)zipEntryInputStream);
                            Jbi.SharedLibrary sharedLibrary = jbiDescriptor.getSharedLibrary();
                            Identification ident = sharedLibrary.getIdentification();
                            ident.setName(JBIConfigureMojo.this.evaluateJBIIdentifier(ident.getName(), artifact));
                            sharedLibrary.setVersion(JBIConfigureMojo.this.evaluateJBIVersion(sharedLibrary.getVersion(), artifact));
                            ByteArrayOutputStream baosUpdatedJbiDesc = new ByteArrayOutputStream();
                            JBIDescriptorBuilder.writeJBIdescriptor((Jbi)jbiDescriptor, (OutputStream)baosUpdatedJbiDesc);
                            zipEntry.setTime(System.currentTimeMillis());
                            return new ByteArrayInputStream(baosUpdatedJbiDesc.toByteArray());
                        }
                        catch (JBIDescriptorException e) {
                            throw new MojoExecutionException("Error reading JBI descriptor.", (Exception)((Object)e));
                        }
                    }
                    return zipEntryInputStream;
                }

                @Override
                public List<Artifact> getExtraEntryToAdd() {
                    return null;
                }
            });
            zipConfiguredArtifactFile.flush();
            zipConfiguredArtifactFile.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("A problem occurs during configuration.", (Exception)e);
        }
    }

    @Override
    protected MavenProject getMavenProject() {
        return this.providedProject;
    }
}

