#!/bin/sh
#
#                      Petals ESB Bootstrap Script
#
# Environment variables:
#
#	JAVA_HOME		Directory containing the JRE. Use the java executable
#					found in $PATH if not defined.
#
#	JAVA_OPTS		Options for the JVM. Try "java -h" to get informations
#					about the available options for your environment
#
#############################################################################

DIRNAME=`dirname "$0"`

# Set the path to the java executable
JAVA="$JAVA_HOME/bin/java"
[ -x "$JAVA" ] || JAVA="`which java`" || {
	echo "ERROR: java executable not found" >&2
	exit 1
}

PETALS_HOME=`cd $DIRNAME/..; pwd`
if [ ! -d "$PETALS_HOME" ]; then
   echo "PETALS_HOME is not valid: $PETALS_HOME" >&2
   exit 1
fi

# Set the path to petals bootstrap jar
PETALS_JAR="$DIRNAME/petals-launcher.jar"
[ -f "$PETALS_JAR" ] || {
	echo "ERROR: petals-launcher.jar: jar archive not found" >&2
	exit 1
}


# Adapt pathes if architecture is Cygwin
case "`uname`" in
	CYGWIN*)
		JAVA="`cygpath --unix "$JAVA"`"
		if [ "$PETALS_HOME" != "" ];
		then
			PETALS_HOME="`cygpath --dos "$PETALS_HOME"`"
		fi
		PETALS_JAR="`cygpath --unix "$PETALS_JAR"`"
		;;
esac
#
if [ -z "$JAVA_OPTS" ]; then
	JAVA_OPTS="-Djava.net.preferIPv4Stack=true -Djavax.xml.transform.TransformerFactory=net.sf.saxon.TransformerFactoryImpl -Xmx1024m -XX:MaxPermSize=256m"
fi

exec "$JAVA" $JAVA_OPTS -Dpetals.home="$PETALS_HOME" -jar "$PETALS_JAR" "$@"
