/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.AttributeErrorException;

public class ConfigurationInstallerComponentClient
extends AbstractServiceClient {
    private MBeanInfo mbeanInfo;
    private ObjectName objectName;

    public ConfigurationInstallerComponentClient(ObjectName objectName, String petalsDomain, MBeanServerConnection beanServerConnection, MBeanInfo mbeanInfo) {
        super(petalsDomain, beanServerConnection);
        this.mbeanInfo = mbeanInfo;
        this.objectName = objectName;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeErrorException {
        try {
            return this.mBeanServerConnection.getAttribute(this.objectName, attribute);
        }
        catch (AttributeNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (MBeanException e) {
            throw new AttributeErrorException(e);
        }
        catch (ReflectionException e) {
            throw new AttributeErrorException(e);
        }
        catch (IOException e) {
            throw new AttributeErrorException(e);
        }
    }

    public void setAttribute(String name, Object value) throws AttributeErrorException {
        try {
            this.mBeanServerConnection.setAttribute(this.objectName, new Attribute(name, value));
        }
        catch (AttributeNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (MBeanException e) {
            throw new AttributeErrorException(e);
        }
        catch (ReflectionException e) {
            throw new AttributeErrorException(e);
        }
        catch (IOException e) {
            throw new AttributeErrorException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new AttributeErrorException(e);
        }
    }

    public Map<MBeanAttributeInfo, Object> getAttributes() throws AttributeErrorException {
        MBeanAttributeInfo[] attrs = null;
        HashMap<MBeanAttributeInfo, Object> attributes = new HashMap<MBeanAttributeInfo, Object>();
        try {
            for (MBeanAttributeInfo info : attrs = this.mbeanInfo.getAttributes()) {
                attributes.put(info, this.mBeanServerConnection.getAttribute(this.objectName, info.getName()));
            }
        }
        catch (AttributeNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (MBeanException e) {
            throw new AttributeErrorException(e);
        }
        catch (ReflectionException e) {
            throw new AttributeErrorException(e);
        }
        catch (IOException e) {
            throw new AttributeErrorException(e);
        }
        return attributes;
    }

    public void setAttributes(Map<MBeanAttributeInfo, Object> attributes) throws AttributeErrorException {
        try {
            for (Map.Entry<MBeanAttributeInfo, Object> info : attributes.entrySet()) {
                this.mBeanServerConnection.setAttribute(this.objectName, new Attribute(info.getKey().getName(), info.getValue()));
            }
        }
        catch (AttributeNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (MBeanException e) {
            throw new AttributeErrorException(e);
        }
        catch (ReflectionException e) {
            throw new AttributeErrorException(e);
        }
        catch (IOException e) {
            throw new AttributeErrorException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new AttributeErrorException(e);
        }
    }
}

