/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.api.IPetalsAdminService;
import org.ow2.petals.jmx.exception.PerformActionErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;

public class PetalsAdminServiceClient
extends AbstractServiceClient
implements IPetalsAdminService {
    public static final String STOP = "stopContainer";
    public static final String SHUTDOWN = "shutdownContainer";
    public static final String RETRIEVE_TOPOLOGY = "retrieveTopology";
    private static final String PETALS_ADMIN_JMX_NAME = "PetalsAdmin";

    public PetalsAdminServiceClient(String petalsDomain, MBeanServerConnection beanServerConnection) throws PetalsAdminDoesNotExistException, PetalsAdminServiceErrorException {
        super(petalsDomain, beanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("name", PETALS_ADMIN_JMX_NAME);
            attributes.put("type", "service");
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new PetalsAdminDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (IOException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
    }

    public void stopContainer() throws PetalsAdminServiceErrorException {
        try {
            this.performAction(STOP, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
    }

    public void shutdownContainer() throws PetalsAdminServiceErrorException {
        try {
            this.performAction(SHUTDOWN, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
    }

    public Set<Map<String, String>> retrieveTopology() throws PetalsAdminServiceErrorException {
        Set result;
        try {
            result = (Set)this.performAction(RETRIEVE_TOPOLOGY, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new PetalsAdminServiceErrorException("Unexpected result type");
        }
        return result;
    }
}

