/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.ws.api.to;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.ow2.petals.kernel.ws.api.to.ContainerInformation;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://petals.ow2.org/ws/1.0", name="subdomain-information")
public class SubdomainInformation {
    @XmlElement(name="subdomain-name", required=true, nillable=false)
    private String name;
    @XmlElement(name="subdomain-mode", required=true, nillable=false)
    private SubdomainMode subdomainMode;
    @XmlElement(name="description", required=false, nillable=true)
    private String description;
    @XmlElement(name="network-time-synchronized", required=false, nillable=true)
    private boolean networkTimeSynchronized;
    @XmlElement(name="containers", required=false, nillable=true)
    private List<ContainerInformation> containers;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubdomainMode getSubdomainMode() {
        return this.subdomainMode;
    }

    public void setSubdomainMode(SubdomainMode subdomainMode) {
        this.subdomainMode = subdomainMode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isNetworkTimeSynchronized() {
        return this.networkTimeSynchronized;
    }

    public void setNetworkTimeSynchronized(boolean networkTimeSynchronized) {
        this.networkTimeSynchronized = networkTimeSynchronized;
    }

    public List<ContainerInformation> getContainers() {
        return this.containers;
    }

    public void setContainers(List<ContainerInformation> containers) {
        this.containers = containers;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubdomainInformation other = (SubdomainInformation)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.subdomainMode != other.subdomainMode) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.networkTimeSynchronized != other.networkTimeSynchronized) {
            return false;
        }
        if (this.containers != null && other.containers != null) {
            if (this.containers.size() != other.containers.size()) {
                return false;
            }
            for (ContainerInformation container : this.containers) {
                if (other.containers.contains(container)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 97 * hash + this.subdomainMode.hashCode();
        hash = 97 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 97 * hash + (this.networkTimeSynchronized ? 1 : 0);
        hash = 97 * hash + (this.containers != null ? this.containers.size() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        toStringBuilder.append("SubdomainInformation [");
        toStringBuilder.append("subdomain-name=").append(this.name).append(", ");
        toStringBuilder.append("subdomain-mode=").append((Object)this.subdomainMode).append(", ");
        toStringBuilder.append("description=").append(this.description).append(", ");
        toStringBuilder.append("network-time-synchronized=").append(this.networkTimeSynchronized).append(", ");
        toStringBuilder.append("containers={");
        if (this.containers != null) {
            for (ContainerInformation container : this.containers) {
                toStringBuilder.append(container).append(", ");
            }
        }
        toStringBuilder.append("}]");
        return toStringBuilder.toString();
    }

    @XmlEnum
    public static enum SubdomainMode {
        MASTERSLAVE,
        FLOODING,
        STANDALONE;

    }
}

