/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import java.net.URISyntaxException;

public enum MEPPatternConstants {
    IN_ONLY("http://www.w3.org/ns/wsdl/in-only"),
    ROBUST_IN_ONLY("http://www.w3.org/ns/wsdl/robust-in-only"),
    IN_OUT("http://www.w3.org/ns/wsdl/in-out"),
    IN_OPTIONAL_OUT("http://www.w3.org/ns/wsdl/in-optional-out"),
    OUT_ONLY("http://www.w3.org/ns/wsdl/out-only"),
    ROBUST_OUT_ONLY("http://www.w3.org/ns/wsdl/robust-out-only"),
    OUT_IN("http://www.w3.org/ns/wsdl/out-in"),
    OUT_OPTIONAL_IN("http://www.w3.org/ns/wsdl/out-optional-in");

    private final String nameSpace;
    private final URI patternURI;

    public static MEPPatternConstants valueOf(URI pattern) {
        MEPPatternConstants result = null;
        if (pattern != null) {
            for (MEPPatternConstants p : MEPPatternConstants.values()) {
                if (!p.nameSpace.equals(pattern.toString())) continue;
                result = p;
            }
        }
        return result;
    }

    private MEPPatternConstants(String nameSpace) {
        this.nameSpace = nameSpace;
        try {
            this.patternURI = new URI(nameSpace);
        }
        catch (URISyntaxException e) {
            throw new Error("Unexpected Error in URI namespace syntax", e);
        }
    }

    public URI value() {
        return this.patternURI;
    }

    public boolean equals(URI pattern) {
        return pattern != null && this.toString().equals(pattern.toString());
    }

    public String toString() {
        return this.nameSpace;
    }
}

