/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.fractal.julia.asm.AbstractClassGenerator;
import org.objectweb.fractal.julia.asm.AbstractCodeGenerator;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.asm.InterceptorClassGenerator;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Tree;

public abstract class SimpleCodeGenerator
extends AbstractCodeGenerator
implements Initializable {
    private Tree args;
    private InterceptorClassGenerator icg;
    private String delegateFieldName;
    private String delegateFieldDesc;
    private String owner;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$objectweb$fractal$julia$InitializationContext;

    public void initialize(Tree args) {
        this.args = args.getSubTree(0);
    }

    public int init(InterceptorClassGenerator icg) {
        this.icg = icg;
        return 0;
    }

    public void generateInitCode(MethodVisitor cv) throws ClassGenerationException {
        String owner = null;
        int i = 0;
        while (i < this.icg.controllerClasses.length) {
            Class c = this.icg.controllerClasses[i];
            ArrayList<Class> params = new ArrayList<Class>();
            if (this.needsInterfaceName()) {
                params.add(class$java$lang$String == null ? SimpleCodeGenerator.class$("java.lang.String") : class$java$lang$String);
            }
            if (this.needsTargetObject()) {
                params.add(class$java$lang$Object == null ? SimpleCodeGenerator.class$("java.lang.Object") : class$java$lang$Object);
            }
            params.add(class$java$lang$String == null ? SimpleCodeGenerator.class$("java.lang.String") : class$java$lang$String);
            Class[] paramClasses = params.toArray(new Class[params.size()]);
            try {
                c.getMethod(this.getPreMethodName(), paramClasses);
                owner = c.getName();
                break;
            }
            catch (Exception e) {
                ++i;
            }
        }
        if (owner == null) {
            throw new ClassGenerationException(null, this.icg.args.toString(), "Cannot find a controller class providing a '" + this.getPreMethodName() + "' method with the good arguments");
        }
        owner = owner.replace('.', '/');
        int hashcode = this.getControllerInterfaceName().hashCode();
        this.delegateFieldName = "d" + Integer.toHexString(hashcode);
        this.delegateFieldDesc = "L" + owner + ";";
        FieldVisitor fv = this.icg.cw.visitField(2, this.delegateFieldName, this.delegateFieldDesc, null, null);
        if (fv != null) {
            fv.visitEnd();
        }
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitLdcInsn((Object)this.getControllerInterfaceName());
        cv.visitMethodInsn(182, Type.getInternalName((Class)(class$org$objectweb$fractal$julia$InitializationContext == null ? (class$org$objectweb$fractal$julia$InitializationContext = SimpleCodeGenerator.class$("org.objectweb.fractal.julia.InitializationContext")) : class$org$objectweb$fractal$julia$InitializationContext)), "getInterface", "(" + Type.getDescriptor((Class)(class$java$lang$String == null ? (class$java$lang$String = SimpleCodeGenerator.class$("java.lang.String")) : class$java$lang$String)) + ")" + Type.getDescriptor((Class)(class$java$lang$Object == null ? (class$java$lang$Object = SimpleCodeGenerator.class$("java.lang.Object")) : class$java$lang$Object)));
        cv.visitTypeInsn(192, owner);
        cv.visitFieldInsn(181, this.icg.name, this.delegateFieldName, this.delegateFieldDesc);
    }

    protected int getInterceptionCodeFormals(Method m) {
        return AbstractClassGenerator.getSize(this.getContextType());
    }

    public void generateCloneCode(MethodVisitor cv) {
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.icg.name, this.delegateFieldName, this.delegateFieldDesc);
        cv.visitFieldInsn(181, this.icg.name, this.delegateFieldName, this.delegateFieldDesc);
    }

    protected void generateInterceptionCodeBlock(Method m, boolean pre, MethodVisitor cv, int formals) {
        String name;
        Class c = this.getContextType();
        String desc = Type.getDescriptor((Class)c);
        cv.visitVarInsn(25, 0);
        if (this.delegateFieldName != null) {
            cv.visitFieldInsn(180, this.icg.name, this.delegateFieldName, this.delegateFieldDesc);
        }
        if (this.needsInterfaceName()) {
            name = this.getInterfaceName(m);
            if (name == null) {
                cv.visitInsn(1);
            } else {
                cv.visitLdcInsn((Object)name);
            }
        }
        if (this.needsTargetObject()) {
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.icg.name, this.icg.implFieldName, this.icg.implFieldDesc);
        }
        cv.visitLdcInsn((Object)this.getMethodName(m));
        if (!pre && c != Void.TYPE) {
            cv.visitVarInsn(21 + AbstractClassGenerator.getOpcodeOffset(c), formals);
        }
        if (this.owner == null) {
            this.owner = this.delegateFieldDesc == null ? this.icg.name : this.delegateFieldDesc.substring(1, this.delegateFieldDesc.length() - 1);
        }
        String string = name = pre ? this.getPreMethodName() : this.getPostMethodName();
        desc = pre ? "Ljava/lang/String;)" + desc : (c != Void.TYPE ? "Ljava/lang/String;" + desc + ")V" : "Ljava/lang/String;)V");
        if (this.needsTargetObject()) {
            desc = "Ljava/lang/Object;" + desc;
        }
        if (this.needsInterfaceName()) {
            desc = "Ljava/lang/String;" + desc;
        }
        cv.visitMethodInsn(182, this.owner, name, "(" + desc);
        if (pre && c != Void.TYPE) {
            cv.visitVarInsn(54 + AbstractClassGenerator.getOpcodeOffset(c), formals);
        }
    }

    protected abstract String getControllerInterfaceName();

    protected abstract String getPreMethodName();

    protected abstract String getPostMethodName();

    protected abstract Class getContextType();

    protected abstract String getMethodName(Method var1);

    protected boolean needsInterfaceName() {
        return false;
    }

    private String getInterfaceName(Method m) {
        if (this.args != null) {
            String desc = m.getName() + Type.getMethodDescriptor((Method)m);
            List itfs = this.icg.interfaces;
            int i = 0;
            while (i < itfs.size()) {
                block6: {
                    Class c;
                    String itf = ((String)itfs.get(i)).replace('/', '.');
                    try {
                        c = this.icg.loader.loadClass(itf, (Object)this.icg.loader);
                    }
                    catch (ClassNotFoundException e) {
                        break block6;
                    }
                    Method[] meths = c.getMethods();
                    int j = 0;
                    while (j < meths.length) {
                        Method meth = meths[j];
                        if (desc.equals(meth.getName() + Type.getMethodDescriptor((Method)meth))) {
                            return this.args.getSubTree(i).toString();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean needsTargetObject() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

