/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.jmx.julia.stat;

import org.objectweb.fractal.jmx.julia.stat.BasicStatController;
import org.objectweb.fractal.julia.loader.Tree;

public class ExponentialSmoothingStatController
extends BasicStatController {
    protected double _alpha = 0.5;
    private double _lastRateOfMethodCall;
    private double _lastRateOfMethodSuccess;

    public void initialize(Tree args) {
        if (args.getSize() == 0) {
            return;
        }
        if (args.getSize() == 1) {
            super.initialize(args);
            return;
        }
        super.initialize(args);
        this._alpha = Double.valueOf(args.getSubTree(1).toString());
        if (this._alpha < 0.0 || this._alpha > 1.0) {
            throw new IllegalStateException("alpha=" + this._alpha + " is invalid. The value must in the interval [0-1].");
        }
    }

    public double getRateOfMethodCall() {
        this._lastRateOfMethodCall = this.expSmoothing(super.getRateOfMethodCall(), this._lastRateOfMethodCall);
        return this._lastRateOfMethodCall;
    }

    public double getRateOfMethodSuccess() {
        this._lastRateOfMethodSuccess = this.expSmoothing(super.getRateOfMethodSuccess(), this._lastRateOfMethodSuccess);
        return this._lastRateOfMethodSuccess;
    }

    public void reset() {
        super.reset();
        this._lastRateOfMethodCall = 0.0;
        this._lastRateOfMethodSuccess = 0.0;
    }

    private double expSmoothing(double newRate, double lastRate) {
        return this._alpha * newRate + (1.0 - this._alpha) * lastRate;
    }
}

