/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.topology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.communication.RemoteCheckerClient;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.configuration.SubDomainConfiguration;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.to.ContainerInformation;
import org.ow2.petals.kernel.ws.api.to.SubdomainInformation;
import org.ow2.petals.kernel.ws.client.KernelWSFactory;
import org.ow2.petals.kernel.ws.client.TopologyServiceClient;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.ws.adapters.TopologyConfigurationToTopologyInformation;
import org.ow2.petals.ws.adapters.TopologyInformationToTopologyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=TopologyService.class)})
public class TopologyServiceImpl
implements BindingController,
LifeCycleController,
TopologyService {
    private static final long TIMER_PERIOD = 5000L;
    private static final long TIMER_START = 2000L;
    protected LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private Map<String, ContainerConfiguration.ContainerState> containerStates = new ConcurrentHashMap<String, ContainerConfiguration.ContainerState>();
    private boolean stopped;
    @Requires(name="remote", signature=RemoteCheckerClient.class)
    private RemoteCheckerClient remoteChecker;
    private Timer topologyTimer;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void addContainerConfiguration(ContainerConfiguration containerConfiguration) throws PetalsException {
        if (containerConfiguration == null) {
            throw new PetalsException("Can't add a null container to the local topology");
        }
        this.configurationService.addContainerConfiguration(containerConfiguration);
    }

    @Override
    public void addSubdomainConfiguration(SubDomainConfiguration subDomainConfiguration) throws PetalsException {
        if (subDomainConfiguration == null) {
            throw new PetalsException("Can't add a null subdomain to the local topology");
        }
        this.configurationService.addSubdomainConfiguration(subDomainConfiguration);
    }

    @Override
    public ContainerConfiguration getContainerConfiguration(String string) {
        return this.configurationService.getContainerConfiguration(string);
    }

    @Override
    public Set<ContainerConfiguration> getContainersConfiguration(ContainerConfiguration.ContainerState containerState) {
        Set<ContainerConfiguration> set = null;
        Set<ContainerConfiguration> set2 = this.configurationService.getContainersConfiguration();
        if (containerState == null) {
            set = set2;
        } else {
            set = new HashSet<ContainerConfiguration>(set2.size());
            for (ContainerConfiguration containerConfiguration : set2) {
                if (containerConfiguration.getState() == null || !containerConfiguration.getState().equals((Object)containerState)) continue;
                set.add(containerConfiguration);
            }
        }
        return set;
    }

    @Override
    public Set<ContainerConfiguration> getContainersConfigurationsForLocalSubdomain() {
        HashSet<ContainerConfiguration> hashSet = new HashSet<ContainerConfiguration>();
        String string = this.retrieveLocalSubdomainName();
        for (ContainerConfiguration containerConfiguration : this.retrieveAllContainersConfigurations()) {
            if (!containerConfiguration.getSubdomainName().equals(string)) continue;
            hashSet.add(containerConfiguration);
        }
        return hashSet;
    }

    @Override
    public DomainConfiguration getDomainConfiguration() {
        return this.configurationService.getDomainConfiguration();
    }

    @Override
    public Set<SubDomainConfiguration> getSubDomainsConfiguration() {
        return this.configurationService.getSubDomainsConfiguration();
    }

    @Override
    public boolean hasValidLocalContainerDynamicTopologyConfiguration() {
        if (this.configurationService.getDomainConfiguration().getMode() != DomainConfiguration.DomainMode.DYNAMIC) {
            return false;
        }
        return this.configurationService.getContainerConfiguration().isSlave() || this.configurationService.getContainerConfiguration().isMaster();
    }

    @Override
    public boolean isContainerStarted(String string) {
        return ContainerConfiguration.ContainerState.STARTED.equals((Object)this.containerStates.get(string));
    }

    @Override
    public void registerLocalContainerOnMaster() throws PetalsException {
        try {
            if (!this.hasValidLocalContainerDynamicTopologyConfiguration()) {
                return;
            }
            if (this.configurationService.getContainerConfiguration().isMaster()) {
                return;
            }
            TopologyServiceClient topologyServiceClient = this.retrieveTopologyServiceWSClient();
            if (topologyServiceClient == null) {
                throw new PetalsException("Can't retrieve remote topology WS client");
            }
            String string = this.retrieveLocalSubdomainName();
            ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
            ContainerInformation containerInformation = TopologyConfigurationToTopologyInformation.containerConfigurationToContainerInformation(containerConfiguration);
            topologyServiceClient.addContainerInformation(containerInformation, string);
        }
        catch (PEtALSWebServiceException pEtALSWebServiceException) {
            throw new PetalsException((Throwable)pEtALSWebServiceException);
        }
    }

    @Override
    public void removeContainerConfiguration(ContainerConfiguration containerConfiguration) throws ConfigurationException {
        this.configurationService.removeContainerConfiguration(containerConfiguration);
    }

    @Override
    public void removeSubdomainConfiguration(String string) throws ConfigurationException {
        this.configurationService.removeSubdomainConfiguration(string);
    }

    @Override
    public void setContainerState(String string, ContainerConfiguration.ContainerState containerState) {
        this.containerStates.put(string, containerState);
    }

    @Override
    public void updateTopology() throws PetalsException {
        if (!this.hasValidLocalContainerDynamicTopologyConfiguration()) {
            return;
        }
        if (this.configurationService.getContainerConfiguration().isMaster()) {
            this.configurationService.backupTopology();
            return;
        }
        TopologyServiceClient topologyServiceClient = this.retrieveTopologyServiceWSClient();
        if (topologyServiceClient == null) {
            throw new PetalsException("Can't retrieve remote topology WS client");
        }
        String string = this.retrieveLocalSubdomainName();
        this.updateLocalSubdomainContainersWithMasterInformations(string, topologyServiceClient);
        this.configurationService.backupTopology();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("remote")) {
            if (!RemoteCheckerClient.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RemoteCheckerClient.class.getName());
            }
            this.remoteChecker = (RemoteCheckerClient)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("remote");
        return arrayList.toArray(new String[0]);
    }

    @Override
    public void validateDynamicTopology() throws ConfigurationException {
        this.configurationService.validateDynamicTopology();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Communication.TopologyService"));
        this.log.call();
        Set<ContainerConfiguration> set = this.configurationService.getContainersConfiguration();
        for (ContainerConfiguration containerConfiguration : set) {
            this.containerStates.put(containerConfiguration.getName(), ContainerConfiguration.ContainerState.UNKNOWN);
        }
        this.stopped = false;
        this.topologyTimer = new Timer("Topology Pinger");
        this.topologyTimer.schedule((TimerTask)new TopologyPinger(), 2000L, 5000L);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("remote")) {
            return this.remoteChecker;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("remote")) {
            this.remoteChecker = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        this.stopped = true;
        this.topologyTimer.cancel();
    }

    private Set<ContainerConfiguration> retrieveAllContainersConfigurations() {
        Set<ContainerConfiguration> set = this.configurationService.getContainersConfiguration();
        return set;
    }

    private ContainerConfiguration retrieveLocalContainerConfiguration() {
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        return containerConfiguration;
    }

    private String retrieveLocalSubdomainName() {
        String string = this.retrieveLocalContainerConfiguration().getName();
        String string2 = null;
        for (ContainerConfiguration containerConfiguration : this.retrieveAllContainersConfigurations()) {
            if (!containerConfiguration.getName().equals(string)) continue;
            string2 = containerConfiguration.getSubdomainName();
            break;
        }
        return string2;
    }

    private ContainerConfiguration retrieveMasterContainerConfiguration() {
        ContainerConfiguration containerConfiguration = null;
        ContainerConfiguration containerConfiguration2 = this.retrieveLocalContainerConfiguration();
        if (containerConfiguration2.isMaster()) {
            containerConfiguration = containerConfiguration2;
        } else {
            Set<ContainerConfiguration> set = this.getContainersConfigurationsForLocalSubdomain();
            for (ContainerConfiguration containerConfiguration3 : set) {
                if (!containerConfiguration3.isMaster()) continue;
                containerConfiguration = containerConfiguration3;
                break;
            }
        }
        return containerConfiguration;
    }

    private TopologyServiceClient retrieveTopologyServiceWSClient() {
        KernelWSFactory kernelWSFactory = KernelWSFactory.getInstance();
        return kernelWSFactory.getTopologyServiceClient(this.retrieveTopologyServiceWSClientAddress());
    }

    private String retrieveTopologyServiceWSClientAddress() {
        ContainerConfiguration containerConfiguration = this.retrieveMasterContainerConfiguration();
        String string = containerConfiguration.getHost();
        int n = containerConfiguration.getWebservicePort();
        return "http://" + string + ":" + n + "/petals/ws/TopologyService";
    }

    private void updateLocalSubdomainContainersWithMasterInformations(String string, TopologyServiceClient topologyServiceClient) throws PetalsException {
        if (string == null) {
            throw new PetalsException("Can't retrieve the local subdomain name");
        }
        if (topologyServiceClient == null) {
            throw new PetalsException("Can't retrieve the topology service client");
        }
        ContainerConfiguration containerConfiguration = this.retrieveMasterContainerConfiguration();
        try {
            SubdomainInformation subdomainInformation = topologyServiceClient.getSubdomainByName(string);
            List list = subdomainInformation.getContainers();
            for (ContainerInformation containerInformation : list) {
                String string2 = containerInformation.getName();
                ContainerConfiguration containerConfiguration2 = this.configurationService.getContainerConfiguration(string2);
                if (containerConfiguration2 != null && containerConfiguration2.isMaster()) {
                    if (!containerConfiguration.getName().equals(containerConfiguration2.getName())) {
                        throw new PetalsException("Another master was retrieved from the master - the topology seems to be corrupted");
                    }
                    break;
                }
                if (containerConfiguration2 != null) {
                    this.configurationService.removeContainerConfiguration(containerConfiguration2);
                }
                ContainerConfiguration containerConfiguration3 = TopologyInformationToTopologyConfiguration.containerInformationToContainerConfiguration(containerInformation);
                containerConfiguration3.setSubdomainName(string);
                this.addContainerConfiguration(containerConfiguration3);
            }
        }
        catch (PEtALSWebServiceException pEtALSWebServiceException) {
            throw new PetalsException((Throwable)pEtALSWebServiceException);
        }
    }

    private class TopologyPinger
    extends TimerTask {
        private TopologyPinger() {
        }

        public void run() {
            for (String string : TopologyServiceImpl.this.containerStates.keySet()) {
                if (TopologyServiceImpl.this.stopped) break;
                if (string.equals(TopologyServiceImpl.this.configurationService.getContainerConfiguration().getName())) continue;
                if (TopologyServiceImpl.this.remoteChecker.ping(string)) {
                    TopologyServiceImpl.this.setContainerState(string, ContainerConfiguration.ContainerState.STARTED);
                    TopologyServiceImpl.this.log.debug((Object)("Container '" + string + "' started"));
                    continue;
                }
                TopologyServiceImpl.this.setContainerState(string, ContainerConfiguration.ContainerState.STOPPED);
                TopologyServiceImpl.this.log.debug((Object)("Container '" + string + "' stopped"));
            }
        }
    }
}

