/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.lifecycle;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.Component;
import javax.jbi.management.ComponentLifeCycleMBean;
import javax.jbi.management.InstallerMBean;
import javax.jbi.messaging.MessagingException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.communication.jndi.client.JNDIService;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.ComponentContextCommunication;
import org.ow2.petals.container.lifecycle.ComponentLifeCycle;
import org.ow2.petals.container.lifecycle.ComponentLifeCycleInterface;
import org.ow2.petals.container.lifecycle.InstallerInterface;
import org.ow2.petals.container.thread.BootstrapThread;
import org.ow2.petals.container.thread.ComponentLifeCycleThread;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.component.context.ComponentContextImpl;
import org.ow2.petals.jbi.component.context.ComponentInitialContext;
import org.ow2.petals.jbi.component.context.InstallationContextImpl;
import org.ow2.petals.jbi.descriptor.original.generated.ClassLoaderDelegationType;
import org.ow2.petals.jbi.descriptor.original.generated.ComponentType;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.messaging.endpoint.JBIServiceEndpointImpl;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.system.classloader.ClassLoaderService;
import org.ow2.petals.system.classloader.PetalsClassLoader;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=InstallerInterface.class)})
public class Installer
implements InstallerMBean,
BindingController,
LifeCycleController,
ComponentContextCommunication,
InstallerInterface {
    public static final String BS_PREFIX = "BS";
    public static final String COMP_PREFIX = "COMP";
    public static final String INSTALLED = "Installed";
    public static final String UNINSTALLED = "Uninstalled";
    private LoggingUtil log;
    @Requires(name="admin", signature=AdminService.class)
    protected AdminService adminService;
    @Requires(name="classloader", signature=ClassLoaderService.class)
    protected ClassLoaderService classloaderService;
    @Requires(name="router", signature=RouterService.class)
    protected RouterService router;
    @Requires(name="repository", signature=RepositoryService.class)
    protected RepositoryService repositoryService;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    protected EndpointRegistry endpointRegistry;
    @Requires(name="jndi", signature=JNDIService.class)
    protected JNDIService jndiService;
    @Requires(name="container", signature=ContainerService.class)
    protected ContainerService container;
    @Requires(contingency=Contingency.OPTIONAL, name="transactionManager", signature=TransactionManager.class)
    protected TransactionManager transactionManager;
    @Requires(name="systemstate", signature=SystemStateService.class)
    protected SystemStateService recoverySrv;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private org.objectweb.fractal.api.Component fractalComponent;
    private ContainerConfiguration containerConfiguration;
    private Context context;
    private String state = "Uninstalled";
    private Jbi jbiDescriptor;
    private String installationRootPath;
    private String workingRootPath;
    private ServiceEndpoint address;
    private InitialContext initialContext;
    private InstallationContextImpl installContext;
    private PetalsClassLoader bootstrapClassLoader;
    private BootstrapThread bootstrapThread;
    private Object activitySynchronizer;
    private ComponentContext componentContext;
    private org.ow2.petals.jbi.descriptor.original.generated.Component componentDescription;
    private String componentName;
    private Bootstrap jbiBootstrap;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void init(Context context) throws IOException, JBIException, NamingException, NoSuchInterfaceException {
        this.context = context;
        this.state = UNINSTALLED;
        this.activitySynchronizer = new Object();
        this.jbiDescriptor = this.context.getDescriptor();
        this.componentDescription = this.jbiDescriptor.getComponent();
        this.componentName = this.componentDescription.getIdentification().getName();
        this.installationRootPath = URLDecoder.decode(this.context.getInstallUrl().getPath());
        this.workingRootPath = this.repositoryService.getComponentWorkDirectory(this.componentName).getAbsolutePath();
        this.address = new JBIServiceEndpointImpl();
        this.address.setType(ServiceEndpoint.EndpointType.CONSUMER);
        this.address.getLocation().setComponentName(this.componentName);
        this.address.getLocation().setContainerName(this.containerConfiguration.getName());
        this.address.getLocation().setSubdomainName(this.containerConfiguration.getSubdomainName());
        this.initialContext = this.createComponentInitialContext();
        this.componentContext = this.createComponentContext();
        this.bootstrapClassLoader = this.createBootstrapClassloader();
        this.jbiBootstrap = this.loadBootstrap(this.bootstrapClassLoader);
        this.installContext = new InstallationContextImpl(this.componentDescription, this.componentContext, true);
        this.bootstrapThread = this.createBootstrapThread(this.bootstrapClassLoader, this.jbiBootstrap);
        this.initBootstrap(true);
    }

    public ObjectName getInstallerConfigurationMBean() throws JBIException {
        return this.bootstrapThread.getExtensionMBeanName();
    }

    public String getInstallRoot() {
        return this.componentContext.getInstallRoot();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        if (string.equals("classloader")) {
            if (!ClassLoaderService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ClassLoaderService.class.getName());
            }
            this.classloaderService = (ClassLoaderService)object;
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.router = (RouterService)object;
            return;
        }
        if (string.equals("repository")) {
            if (!RepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RepositoryService.class.getName());
            }
            this.repositoryService = (RepositoryService)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("jndi")) {
            if (!JNDIService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JNDIService.class.getName());
            }
            this.jndiService = (JNDIService)object;
            return;
        }
        if (string.equals("container")) {
            if (!ContainerService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ContainerService.class.getName());
            }
            this.container = (ContainerService)object;
            return;
        }
        if (string.equals("transactionManager")) {
            if (!TransactionManager.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TransactionManager.class.getName());
            }
            this.transactionManager = (TransactionManager)object;
            return;
        }
        if (string.equals("systemstate")) {
            if (!SystemStateService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SystemStateService.class.getName());
            }
            this.recoverySrv = (SystemStateService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("component")) {
            this.fractalComponent = (org.objectweb.fractal.api.Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectName install() throws JBIException {
        this.log.start();
        ObjectName objectName = null;
        try {
            if (!UNINSTALLED.equals(this.state)) {
                throw new JBIException("The Installer can not be installed in this state: " + this.state);
            }
            Object object = this.activitySynchronizer;
            synchronized (object) {
                try {
                    this.bootstrapThread.onInstall();
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    this.bootstrapThread.cleanUp();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                this.bootstrapThread.cleanUp();
                objectName = this.createComponentLifeCycleMBean();
                this.setState(INSTALLED);
            }
        }
        catch (JBIException jBIException) {
            this.log.error((Object)jBIException.getMessage(), (Throwable)jBIException);
            throw jBIException;
        }
        this.log.info((Object)("Component '" + this.componentName + "' installed"));
        this.log.end();
        return objectName;
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("admin");
        arrayList.add("classloader");
        arrayList.add("router");
        arrayList.add("repository");
        arrayList.add("endpoint");
        arrayList.add("jndi");
        arrayList.add("container");
        arrayList.add("transactionManager");
        arrayList.add("systemstate");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("admin")) {
            return this.adminService;
        }
        if (string.equals("classloader")) {
            return this.classloaderService;
        }
        if (string.equals("router")) {
            return this.router;
        }
        if (string.equals("repository")) {
            return this.repositoryService;
        }
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("jndi")) {
            return this.jndiService;
        }
        if (string.equals("container")) {
            return this.container;
        }
        if (string.equals("transactionManager")) {
            return this.transactionManager;
        }
        if (string.equals("systemstate")) {
            return this.recoverySrv;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        if (string.equals("classloader")) {
            this.classloaderService = null;
            return;
        }
        if (string.equals("router")) {
            this.router = null;
            return;
        }
        if (string.equals("repository")) {
            this.repositoryService = null;
            return;
        }
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("jndi")) {
            this.jndiService = null;
            return;
        }
        if (string.equals("container")) {
            this.container = null;
            return;
        }
        if (string.equals("transactionManager")) {
            this.transactionManager = null;
            return;
        }
        if (string.equals("systemstate")) {
            this.recoverySrv = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws JBIException {
        block8: {
            this.log.start();
            try {
                if (this.adminService.getServiceUnitsLifeCyclesForComponent(this.componentName).size() != 0) {
                    throw new JBIException("Can not uninstall a component which holds deployed Service Unit(s)");
                }
                ComponentLifeCycleMBean componentLifeCycleMBean = null;
                componentLifeCycleMBean = this.adminService.isEngine(this.componentName) ? this.adminService.getEngineComponentLifeCycleByName(this.componentName) : this.adminService.getBindingComponentLifeCycleByName(this.componentName);
                if (componentLifeCycleMBean == null) {
                    throw new JBIException("The component '" + this.componentName + "' can not be uninstalled as it is not installed!");
                }
                String string = componentLifeCycleMBean.getCurrentState();
                if (INSTALLED.equals(this.state) && ("Shutdown".equals(string) || "Unknown".equals(string))) {
                    Object object = this.activitySynchronizer;
                    synchronized (object) {
                        this.doUninstall();
                        this.setState(UNINSTALLED);
                        break block8;
                    }
                }
                throw new JBIException("The component '" + this.componentName + "' can not be uninstalled in the Installer state: " + this.state + " and Component state: " + string);
            }
            catch (JBIException jBIException) {
                this.log.error((Object)jBIException.getMessage(), (Throwable)jBIException);
                throw jBIException;
            }
        }
        this.log.info((Object)("Component '" + this.componentName + "' uninstalled"));
        this.log.end();
    }

    public boolean isInstalled() {
        return INSTALLED.equals(this.state);
    }

    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public ServiceEndpoint getAddress() {
        return this.address;
    }

    @Override
    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    @Override
    public InitialContext getInitialContext() {
        return this.initialContext;
    }

    @Override
    public String getInstallationRoot() {
        return this.installationRootPath;
    }

    @Override
    public Jbi getJBIDescriptor() {
        return this.jbiDescriptor;
    }

    @Override
    public AdminService getAdminService() {
        return this.adminService;
    }

    @Override
    public RouterService getRouterService() {
        return this.router;
    }

    @Override
    public TransactionManager getTransactionManagerService() {
        return this.transactionManager;
    }

    @Override
    public String getWorkspaceRoot() {
        return this.workingRootPath;
    }

    @Override
    public Logger getLogger() {
        return this.log.getLogger();
    }

    public Component getComponent() {
        return this.componentContext.getComponent();
    }

    public void initBootstrap(boolean bl) throws JBIException {
        this.installContext.setInstall(bl);
        try {
            this.bootstrapThread.init(this.installContext);
        }
        catch (JBIException jBIException) {
            this.bootstrapThread.cleanUp();
            throw jBIException;
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws JBIException, PetalsException {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Container.Lifecycle.Installer"));
        this.log.start();
        this.containerConfiguration = this.configurationService.getContainerConfiguration();
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        try {
            this.bootstrapThread.shutdownThread();
        }
        catch (JBIException jBIException) {
            this.log.warning((Object)("Failed to stop the Bootstrap thread : " + jBIException.getMessage()));
        }
        this.log = null;
    }

    private void setState(String string) throws JBIException {
        this.state = string;
        try {
            this.recoverySrv.updateComponentInstallationState(this.getComponentName(), string);
        }
        catch (Exception exception) {
            throw new JBIException("Installer state can't be persisted for recovery", (Throwable)exception);
        }
    }

    private PetalsClassLoader createBootstrapClassloader() {
        this.log.call();
        List list = this.componentDescription.getBootstrapClassPath().getPathElement();
        int n = 0;
        while (n < list.size()) {
            ((String)list.get(n)).trim();
            n += 1;
        }
        n = ClassLoaderDelegationType.SELF_FIRST.equals((Object)this.componentDescription.getBootstrapClassLoaderDelegation()) ? 0 : 1;
        return this.createClassLoader(BS_PREFIX, list, n != 0, null);
    }

    private PetalsClassLoader createClassLoader(String string, List<String> list, boolean bl, List<String> list2) {
        this.log.start();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            arrayList.add(new File(this.installationRootPath).toURI().toURL());
        }
        catch (Exception exception) {
            this.log.warning((Object)"Unexpected error", (Throwable)exception);
        }
        URL[] uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        PetalsClassLoader petalsClassLoader = null;
        try {
            petalsClassLoader = (PetalsClassLoader)this.classloaderService.createComponentClassLoader(String.valueOf(string) + this.componentName, uRLArray, list, bl, list2);
        }
        catch (PetalsException petalsException) {
            this.log.error((Object)("Failed to create bootstrap class loader" + petalsException.getMessage()), (Throwable)petalsException);
        }
        this.log.end();
        return petalsClassLoader;
    }

    private PetalsClassLoader createComponentClassloader() {
        PetalsClassLoader petalsClassLoader2;
        this.log.start();
        List<String> list = this.installContext.getClassPathElements();
        boolean bl = !ClassLoaderDelegationType.SELF_FIRST.equals((Object)this.componentDescription.getComponentClassLoaderDelegation());
        List list2 = this.componentDescription.getSharedLibraryList();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list2 != null) {
            for (PetalsClassLoader petalsClassLoader2 : list2) {
                arrayList.add(String.valueOf(petalsClassLoader2.getContent().trim()) + "-" + petalsClassLoader2.getVersion());
            }
        }
        petalsClassLoader2 = this.createClassLoader(COMP_PREFIX, list, bl, arrayList);
        this.log.end();
        return petalsClassLoader2;
    }

    private BootstrapThread createBootstrapThread(PetalsClassLoader petalsClassLoader, Bootstrap bootstrap) {
        BootstrapThread bootstrapThread = new BootstrapThread(this.getComponentName(), bootstrap, this.containerConfiguration.getTaskTimeout(), this.log);
        bootstrapThread.setContextClassLoader(petalsClassLoader);
        bootstrapThread.start();
        return bootstrapThread;
    }

    private ComponentLifeCycleThread createComponentLifeCycleThread(Component component, PetalsClassLoader petalsClassLoader) {
        ComponentLifeCycleThread componentLifeCycleThread = new ComponentLifeCycleThread(component, this.containerConfiguration.getTaskTimeout(), this.log);
        componentLifeCycleThread.setContextClassLoader(petalsClassLoader);
        componentLifeCycleThread.start();
        return componentLifeCycleThread;
    }

    private ObjectName createComponentLifeCycleMBean() throws JBIException {
        this.log.start();
        ObjectName objectName = null;
        PetalsClassLoader petalsClassLoader = this.createComponentClassloader();
        Component component = this.loadComponent(petalsClassLoader);
        this.componentContext.setComponent(component);
        ComponentLifeCycleThread componentLifeCycleThread = this.createComponentLifeCycleThread(component, petalsClassLoader);
        try {
            org.objectweb.fractal.api.Component component2 = this.container.createComponentLifeCycle(this.componentDescription);
            FractalHelper.startComponent(component2);
            ((ComponentLifeCycleInterface)component2.getFcInterface("service")).init(this.componentContext, componentLifeCycleThread, this.context);
            this.router.addComponent(this.componentContext);
            ComponentLifeCycle componentLifeCycle = (ComponentLifeCycle)component2.getFcInterface("/content");
            if (ComponentType.BINDING_COMPONENT.equals((Object)this.componentDescription.getType())) {
                objectName = this.adminService.registerBindingComponent(componentLifeCycle, this.componentName);
            } else if (ComponentType.SERVICE_ENGINE.equals((Object)this.componentDescription.getType())) {
                objectName = this.adminService.registerEngineComponent(componentLifeCycle, this.componentName);
            }
        }
        catch (RoutingException routingException) {
            throw new JBIException((Throwable)((Object)routingException));
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new JBIException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new JBIException((Throwable)illegalLifeCycleException);
        }
        catch (PetalsException petalsException) {
            throw new JBIException((Throwable)petalsException);
        }
        this.log.end();
        return objectName;
    }

    private ComponentContext createComponentContext() throws NoSuchInterfaceException {
        ComponentContextImpl componentContextImpl = new ComponentContextImpl((ComponentContextCommunication)this.fractalComponent.getFcInterface("/content"));
        this.context.setComponentContext(componentContextImpl);
        return componentContextImpl;
    }

    private InitialContext createComponentInitialContext() throws NamingException {
        ComponentInitialContext componentInitialContext = null;
        componentInitialContext = new ComponentInitialContext(this.jndiService.getUsersContext());
        return componentInitialContext;
    }

    private void unregisterComponentLifeCycleMBean() throws ManagementException {
        if (this.componentDescription != null) {
            if (ComponentType.BINDING_COMPONENT.equals((Object)this.componentDescription.getType())) {
                this.adminService.unregisterBindingComponent(this.componentName);
            } else if (ComponentType.SERVICE_ENGINE.equals((Object)this.componentDescription.getType())) {
                this.adminService.unregisterEngineComponent(this.componentName);
            }
        }
    }

    private Bootstrap loadBootstrap(PetalsClassLoader petalsClassLoader) throws JBIException {
        this.log.call();
        Bootstrap bootstrap = null;
        try {
            Class<?> clazz = petalsClassLoader.loadClass(this.componentDescription.getBootstrapClassName().trim());
            if (clazz == null) {
                throw new JBIException("Could not find bootstrap class: " + this.componentDescription.getBootstrapClassName());
            }
            bootstrap = (Bootstrap)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JBIException("Class not found: " + this.componentDescription.getBootstrapClassName(), (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new JBIException("Could not instantiate : " + this.componentDescription.getBootstrapClassName(), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JBIException("Illegal access on: " + this.componentDescription.getBootstrapClassName(), (Throwable)illegalAccessException);
        }
        return bootstrap;
    }

    private Component loadComponent(PetalsClassLoader petalsClassLoader) throws JBIException {
        Component component;
        this.log.call();
        try {
            Class<?> clazz = petalsClassLoader.loadClass(this.componentDescription.getComponentClassName().getContent().trim());
            if (clazz == null) {
                throw new JBIException("Could not find component class: " + this.componentDescription.getComponentClassName());
            }
            component = (Component)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JBIException("Class not found: " + this.componentDescription.getComponentClassName(), (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new JBIException("Could not instantiate : " + this.componentDescription.getComponentClassName(), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JBIException("Illegal access on: " + this.componentDescription.getComponentClassName(), (Throwable)illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new JBIException("Security exception for java.util.logging.Logger", (Throwable)securityException);
        }
        return component;
    }

    private void doUninstall() {
        this.log.start();
        try {
            if (this.componentContext.getDeliveryChannel() != null && this.componentContext.getDeliveryChannel().isOpened()) {
                this.log.debug((Object)"close the component DeliveryChannel");
                this.componentContext.getDeliveryChannel().close();
            }
        }
        catch (MessagingException messagingException) {
            this.log.error((Object)"Unable to close the delivery channel: ", (Throwable)messagingException);
        }
        try {
            this.componentContext.deregisterAllEndpoints();
        }
        catch (JBIException jBIException) {
            this.log.error((Object)"Unable to unregistered all remaining endpoints: ", (Throwable)jBIException);
        }
        try {
            this.bootstrapThread.onUninstall();
        }
        catch (JBIException jBIException) {
            this.log.error((Object)"Unable to uninstall the bootstap: ", (Throwable)jBIException);
        }
        try {
            this.bootstrapThread.cleanUp();
        }
        catch (JBIException jBIException) {
            this.log.error((Object)"Unable to clean up the bootstap: ", (Throwable)jBIException);
        }
        try {
            this.unregisterComponentLifeCycleMBean();
        }
        catch (ManagementException managementException) {
            this.log.error((Object)"Unable to unregister the component lifecycle: ", (Throwable)((Object)managementException));
        }
        try {
            ObjectName objectName;
            if (this.componentContext.getComponent().getLifeCycle() != null && (objectName = this.componentContext.getComponent().getLifeCycle().getExtensionMBeanName()) != null) {
                this.adminService.getMBeanServer().unregisterMBean(objectName);
            }
        }
        catch (Exception exception) {
            this.log.error((Object)"Unable to unregister the extension of the component: ", (Throwable)exception);
        }
        try {
            this.router.removeComponent(this.componentContext);
        }
        catch (RoutingException routingException) {
            this.log.error((Object)"Unable to inform the router about the component uninstallation: ", (Throwable)((Object)routingException));
        }
        try {
            this.container.removeComponentLifeCycle(this.componentDescription);
        }
        catch (PetalsException petalsException) {
            this.log.error((Object)"Unable to remove the fractal component: ", (Throwable)petalsException);
        }
        this.componentContext.clear();
        this.classloaderService.deleteClassLoader(COMP_PREFIX + this.componentName);
        this.classloaderService.deleteClassLoader(BS_PREFIX + this.componentName);
        this.log.end();
    }
}

