/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.container.lifecycle.AbstractLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceAssembly;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
public class ServiceAssemblyLifeCycle
extends AbstractLifeCycle
implements BindingController,
LifeCycleController {
    @Requires(name="systemstate", signature=SystemStateService.class)
    private SystemStateService systemState;
    @Requires(name="router", signature=RouterService.class)
    private RouterService routerService;
    private Component comp;
    private ServiceAssembly serviceAssembly;
    private List<ServiceUnitLifeCycle> serviceUnitsLifeCycles;

    public String getFcState() {
        return null;
    }

    public Component getComponent() {
        return this.comp;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.startComponentLifeCycle();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void init(ServiceAssembly serviceAssembly) throws JBIException {
        this.serviceAssembly = serviceAssembly;
        this.name = serviceAssembly.getIdentification().getName();
        this.setState("Shutdown");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stopComponentLifeCycle();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void doInit() throws JBIException {
    }

    @Override
    public void doShutdown() throws JBIException {
        ArrayList<ServiceUnitLifeCycle> arrayList = new ArrayList<ServiceUnitLifeCycle>(this.serviceUnitsLifeCycles);
        ArrayList<ServiceUnitLifeCycle> arrayList2 = new ArrayList<ServiceUnitLifeCycle>(arrayList);
        Collections.reverse(arrayList2);
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : arrayList) {
            try {
                if ("Stopped".equals(serviceUnitLifeCycle.getCurrentState())) {
                    serviceUnitLifeCycle.shutDown();
                } else if (!this.forcedState) {
                    throw new JBIException("Unable to shut down a service unit which is not stopped");
                }
                if (!"Unknown".equals(serviceUnitLifeCycle.getCurrentState()) || this.forcedState) continue;
                throw new JBIException("Unable to shutdown a service unit");
            }
            catch (JBIException jBIException) {
                if (this.forcedState) continue;
                throw jBIException;
            }
        }
    }

    @Override
    public void doStart() throws JBIException {
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : this.serviceUnitsLifeCycles) {
            if ("Shutdown".equals(serviceUnitLifeCycle.getCurrentState())) {
                serviceUnitLifeCycle.init();
            }
            if (!"Unknown".equals(serviceUnitLifeCycle.getCurrentState())) continue;
            throw new JBIException("Unable to initialize a service unit");
        }
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : this.serviceUnitsLifeCycles) {
            if ("Stopped".equals(serviceUnitLifeCycle.getCurrentState())) {
                serviceUnitLifeCycle.start();
            }
            if (!"Unknown".equals(serviceUnitLifeCycle.getCurrentState())) continue;
            throw new JBIException("Unable to start a service unit");
        }
    }

    @Override
    public void doStop() throws JBIException {
        ArrayList<ServiceUnitLifeCycle> arrayList = new ArrayList<ServiceUnitLifeCycle>(this.serviceUnitsLifeCycles);
        ArrayList<ServiceUnitLifeCycle> arrayList2 = new ArrayList<ServiceUnitLifeCycle>(arrayList);
        Collections.reverse(arrayList);
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : arrayList2) {
            try {
                if ("Started".equals(serviceUnitLifeCycle.getCurrentState())) {
                    serviceUnitLifeCycle.stop();
                } else if (!this.forcedState) {
                    throw new JBIException("Unable to stop a service unit which is not started");
                }
                if (!"Unknown".equals(serviceUnitLifeCycle.getCurrentState()) || this.forcedState) continue;
                throw new JBIException("Unable to stop a service unit");
            }
            catch (JBIException jBIException) {
                if (this.forcedState) continue;
                throw jBIException;
            }
        }
    }

    public ServiceAssembly getServiceAssembly() {
        return this.serviceAssembly;
    }

    public void setServiceAssembly(ServiceAssembly serviceAssembly) {
        this.serviceAssembly = serviceAssembly;
    }

    public List<ServiceUnitLifeCycle> getServiceUnitLifeCycles() {
        return this.serviceUnitsLifeCycles;
    }

    public void registerSU(ServiceUnitLifeCycle serviceUnitLifeCycle) throws JBIException {
        if (this.serviceUnitsLifeCycles.contains(serviceUnitLifeCycle.getSuName())) {
            throw new JBIException("Duplicate service unit : same name");
        }
        this.serviceUnitsLifeCycles.add(serviceUnitLifeCycle);
    }

    public void unregisterSU(ServiceUnitLifeCycle serviceUnitLifeCycle) {
        this.serviceUnitsLifeCycles.remove(serviceUnitLifeCycle);
    }

    @Override
    public void setState(String string) throws JBIException {
        super.setState(string);
        this.routerService.modifiedSALifeCycle(this.serviceUnitsLifeCycles);
        try {
            this.systemState.updateServiceAssemblyState(this.name, string);
        }
        catch (Exception exception) {
            throw new JBIException("Failed to persist the state of the Service Assembly '" + this.name + "'", (Throwable)exception);
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void startComponentLifeCycle() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Container.Lifecycle.ServiceAssemblyLifeCycle"));
        this.log.call();
        this.serviceUnitsLifeCycles = new ArrayList<ServiceUnitLifeCycle>();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stopComponentLifeCycle() throws JBIException {
        this.log.call();
        if ("Started".equals(this.getCurrentState())) {
            try {
                this.doStop();
                this.doShutdown();
            }
            catch (JBIException jBIException) {
                this.log.error((Object)("Failed to stop the Service Assembly '" + this.name + "'"), (Throwable)jBIException);
            }
        }
        if ("Stopped".equals(this.getCurrentState())) {
            try {
                this.doShutdown();
            }
            catch (JBIException jBIException) {
                this.log.error((Object)("Failed to shut down the Service Assembly '" + this.name + "'"), (Throwable)jBIException);
            }
        }
    }

    @Override
    protected String getJBIArtifactType() {
        return "Service Assembly";
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("systemstate")) {
            if (!SystemStateService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SystemStateService.class.getName());
            }
            this.systemState = (SystemStateService)object;
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.routerService = (RouterService)object;
            return;
        }
        if (string.equals("component")) {
            this.comp = (Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("systemstate");
        arrayList.add("router");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("systemstate")) {
            return this.systemState;
        }
        if (string.equals("router")) {
            return this.routerService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("systemstate")) {
            this.systemState = null;
            return;
        }
        if (string.equals("router")) {
            this.routerService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

