/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.system.classloader.ClassLoaderService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SharedLibraryLifeCycle.class)})
public class SharedLibraryLifeCycleImpl
implements BindingController,
LifeCycleController,
SharedLibraryLifeCycle {
    public static final String INSTALLED = "Installed";
    public static final String UNINSTALLED = "Uninstalled";
    private String state = "Uninstalled";
    private LoggingUtil log;
    private Jbi.SharedLibrary sharedLibrary;
    private final List<String> componentNames = new ArrayList<String>();
    private URL[] baseUrls;
    private boolean useParentFirst;
    @Requires(name="classloader", signature=ClassLoaderService.class)
    private ClassLoaderService loaderService;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void init(Jbi.SharedLibrary sharedLibrary, URL[] uRLArray, boolean bl) {
        this.sharedLibrary = sharedLibrary;
        this.baseUrls = uRLArray;
        this.useParentFirst = bl;
        this.state = UNINSTALLED;
    }

    @Override
    public boolean isLoaded() {
        return INSTALLED.equals(this.state);
    }

    @Override
    public void loadSharedLibrary() throws PetalsException {
        this.log.start();
        String string = this.sharedLibrary.getIdentification().getName();
        String string2 = this.sharedLibrary.getVersion();
        String string3 = String.valueOf(string) + "-" + string2;
        List list = this.sharedLibrary.getSharedLibraryClassPath().getPathElement();
        this.loaderService.createSharedLibraryClassLoader(string3, this.baseUrls, list, this.useParentFirst);
        this.state = INSTALLED;
        this.log.info((Object)("Shared library '" + string + "' (" + string2 + ") loaded."));
        this.log.end();
    }

    @Override
    public void unLoadSharedLibrary() {
        this.log.start();
        String string = String.valueOf(this.sharedLibrary.getIdentification().getName()) + "-" + this.sharedLibrary.getVersion();
        this.loaderService.deleteClassLoader(string);
        this.state = UNINSTALLED;
        this.log.end();
    }

    @Override
    public void registerComponent(String string) {
        this.componentNames.add(string);
    }

    @Override
    public void unregisterComponent(String string) {
        this.componentNames.remove(string);
    }

    @Override
    public List<String> getRegisteredComponents() {
        return this.componentNames;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Container.Lifecycle.SharedLibraryLifeCycle"));
        this.log.call();
    }

    @Override
    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.call();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("classloader")) {
            if (!ClassLoaderService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ClassLoaderService.class.getName());
            }
            this.loaderService = (ClassLoaderService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("classloader");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("classloader")) {
            return this.loaderService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("classloader")) {
            this.loaderService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

