/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.installation;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.communication.jmx.JMXService;
import org.ow2.petals.jbi.management.installation.ComponentInstallationService;
import org.ow2.petals.jbi.management.installation.InstallationServiceMBean;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ComponentInstallationService.class)})
public class ComponentInstallationServiceImpl
implements BindingController,
LifeCycleController,
ComponentInstallationService {
    private LoggingUtil log;
    @Requires(name="installation", signature=InstallationServiceMBean.class)
    private InstallationServiceMBean installationService;
    @Requires(name="jmx", signature=JMXService.class)
    private JMXService jmxService;

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.JBI-Management.ComponentInstallationService"));
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
    }

    public boolean install(URL uRL) {
        this.log.debug((Object)("Installing component from " + uRL));
        boolean bl = true;
        try {
            Object object;
            String[] stringArray;
            Object[] objectArray;
            MBeanServer mBeanServer = this.jmxService.getLocalJMXServer();
            ObjectName objectName = this.installationService.loadNewInstaller(uRL.toString());
            if (!objectName.getDomain().equals("error")) {
                objectArray = new Object[0];
                stringArray = new String[0];
                object = mBeanServer.invoke(objectName, "install", objectArray, stringArray);
                if (!(object instanceof ObjectName)) {
                    throw new Exception("The install() invokation on the component installer has returned an unexpected object: " + bl);
                }
            } else {
                throw new Exception("Component can't be installed");
            }
            ObjectName objectName2 = (ObjectName)object;
            mBeanServer.invoke(objectName2, "start", objectArray, stringArray);
        }
        catch (Throwable throwable) {
            this.log.error((Object)"Error occured during auto installation: ", throwable);
            bl = false;
        }
        return bl;
    }

    public String getFcState() {
        return null;
    }

    public boolean uninstall(String string) {
        this.log.debug((Object)("Uninstall component " + string));
        return this.installationService.forceUnloadInstaller(string);
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("installation")) {
            if (!InstallationServiceMBean.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + InstallationServiceMBean.class.getName());
            }
            this.installationService = (InstallationServiceMBean)object;
            return;
        }
        if (string.equals("jmx")) {
            if (!JMXService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JMXService.class.getName());
            }
            this.jmxService = (JMXService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("installation");
        arrayList.add("jmx");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("installation")) {
            return this.installationService;
        }
        if (string.equals("jmx")) {
            return this.jmxService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("installation")) {
            this.installationService = null;
            return;
        }
        if (string.equals("jmx")) {
            this.jmxService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

