/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractSUsTask
extends AbstractLoggableTask {
    protected RepositoryService repositoryService;

    public ExtractSUsTask(LoggingUtil loggingUtil, RepositoryService repositoryService) {
        super(loggingUtil);
        this.repositoryService = repositoryService;
    }

    @Override
    public void execute(Context context) throws Exception {
        Map<String, URL> map = this.expandSUs(context.getInstallUrl(), context.getDescriptor());
        context.setSuInstallUrls(map);
    }

    protected Map<String, URL> expandSUs(URL uRL, Jbi jbi) throws MalformedURLException, ManagementException, PetalsException {
        HashMap<String, URL> hashMap = new HashMap<String, URL>();
        List list = jbi.getServiceAssembly().getServiceUnit();
        for (ServiceUnit serviceUnit : list) {
            String string = serviceUnit.getTarget().getArtifactsZip().trim();
            URL uRL2 = new File(URLDecoder.decode(uRL.getPath()), string).toURI().toURL();
            URL uRL3 = this.expandSUIntoSA(serviceUnit.getIdentification().getName(), uRL2, jbi.getServiceAssembly().getIdentification().getName());
            hashMap.put(serviceUnit.getIdentification().getName(), uRL3);
        }
        return hashMap;
    }

    protected URL expandSUIntoSA(String string, URL uRL, String string2) throws ManagementException {
        URL uRL2 = null;
        try {
            File file = this.repositoryService.explodeSUIntoSAInstallDirectory(string, uRL, string2);
            uRL2 = file.toURI().toURL();
        }
        catch (IOException iOException) {
            throw new ManagementException("Unexpected error expending service JBI installation package into repository", iOException);
        }
        return uRL2;
    }

    @Override
    public void undo(Context context) throws Exception {
    }
}

