/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.undeploy;

import java.util.ArrayList;
import java.util.Collections;
import javax.jbi.JBIException;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.jbi.management.util.XMLResult;
import org.ow2.petals.util.LoggingUtil;

public class UndeployAllSUsTask
extends AbstractLoggableTask {
    protected AdminService adminService;

    public UndeployAllSUsTask(LoggingUtil loggingUtil, AdminService adminService) {
        super(loggingUtil);
        this.adminService = adminService;
    }

    public void execute(Context context) throws Exception {
        if (context.getSaLifeCycle() != null && context.getXmlResult() != null) {
            this.undeploySUS(context.getSaLifeCycle(), context.getXmlResult());
        }
    }

    protected void undeploySUS(ServiceAssemblyLifeCycle serviceAssemblyLifeCycle, XMLResult xMLResult) throws JBIException {
        StringBuffer stringBuffer;
        String string = serviceAssemblyLifeCycle.getCurrentState();
        if (string != null && ("Shutdown".equals(string) || "Unknown".equals(string))) {
            ArrayList<ServiceUnitLifeCycle> arrayList = new ArrayList<ServiceUnitLifeCycle>(serviceAssemblyLifeCycle.getServiceUnitLifeCycles());
            Collections.reverse(arrayList);
            stringBuffer = new StringBuffer();
            for (ServiceUnitLifeCycle serviceUnitLifeCycle : arrayList) {
                String string2 = this.undeploySU(serviceUnitLifeCycle);
                serviceAssemblyLifeCycle.unregisterSU(serviceUnitLifeCycle);
                stringBuffer.append(string2);
            }
        } else {
            throw new JBIException("Service Assembly can't be undeployed in this state: " + string);
        }
        xMLResult.addComponentTaskResult(stringBuffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String undeploySU(ServiceUnitLifeCycle serviceUnitLifeCycle) {
        String string = null;
        Installer installer = this.adminService.getInstallerByName(serviceUnitLifeCycle.getTargetComponentName());
        if (installer == null) {
            this.log.error((Object)("The component '" + serviceUnitLifeCycle.getTargetComponentName() + "' is not deployed. The service unit cannot be undeployed from it."));
            return string;
        }
        ServiceUnitManager serviceUnitManager = installer.getComponent().getServiceUnitManager();
        if (serviceUnitManager == null) {
            this.log.error((Object)("The service unit manager is null for the component '" + serviceUnitLifeCycle.getTargetComponentName() + "'. The service units can not be undeployed from it."));
            return string;
        }
        try {
            try {
                Thread.currentThread().setContextClassLoader(serviceUnitManager.getClass().getClassLoader());
                string = serviceUnitManager.undeploy(serviceUnitLifeCycle.getSuName(), serviceUnitLifeCycle.getServiceUnitRootPath());
            }
            catch (DeploymentException deploymentException) {
                this.log.error((Object)("The service unit manager of the component '" + serviceUnitLifeCycle.getTargetComponentName() + "' cannot  undeploy a service unit."));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            throw throwable;
        }
        {
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            return string;
        }
    }

    public void undo(Context context) throws Exception {
    }
}

