/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.undeploy;

import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

public class UnregisterSALifeCycleTask
extends AbstractLoggableTask {
    protected AdminService adminService;
    protected ContainerService containerService;

    public UnregisterSALifeCycleTask(LoggingUtil loggingUtil, AdminService adminService, ContainerService containerService) {
        super(loggingUtil);
        this.adminService = adminService;
        this.containerService = containerService;
    }

    public void execute(Context context) {
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle;
        String string = context.getEntityName();
        if (string != null) {
            try {
                this.adminService.unregisterServiceAssembly(string);
            }
            catch (ManagementException managementException) {
                this.log.error((Object)"Unable to unregister a service assembly", (Throwable)((Object)managementException));
            }
        }
        if ((serviceAssemblyLifeCycle = context.getSaLifeCycle()) != null) {
            try {
                this.containerService.removeServiceAssemblyLifeCycle(serviceAssemblyLifeCycle);
            }
            catch (PetalsException petalsException) {
                this.log.error((Object)"Unable to remove a fractal service assembly lifecycle", (Throwable)petalsException);
            }
        }
    }

    public void undo(Context context) throws Exception {
    }
}

