/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.system.persistence.PersistenceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistedMessageExchangeWrapper
extends MessageExchangeWrapper {
    private PersistenceService persistenceService;

    public PersistedMessageExchangeWrapper(MessageExchangeImpl messageExchangeImpl, MessageExchange.Role role) {
        super(messageExchangeImpl, role);
    }

    public Fault createFault() throws MessagingException {
        this.checkExchange();
        return super.createFault();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        this.checkExchange();
        return super.createMessage();
    }

    public ServiceEndpoint getConsumerEndpoint() {
        this.checkExchange();
        return (ServiceEndpoint)super.getConsumerEndpoint();
    }

    public javax.jbi.servicedesc.ServiceEndpoint getEndpoint() {
        this.checkExchange();
        return super.getEndpoint();
    }

    public Exception getError() {
        this.checkExchange();
        return super.getError();
    }

    public Fault getFault() {
        this.checkExchange();
        return super.getFault();
    }

    public QName getInterfaceName() {
        this.checkExchange();
        return super.getInterfaceName();
    }

    public NormalizedMessage getMessage(String string) {
        this.checkExchange();
        return super.getMessage(string);
    }

    public MessageExchangeImpl getMessageExchange() {
        this.checkExchange();
        return super.getMessageExchange();
    }

    public Map<String, NormalizedMessage> getMessages() {
        this.checkExchange();
        return super.getMessages();
    }

    public QName getOperation() {
        this.checkExchange();
        return super.getOperation();
    }

    public URI getPattern() {
        this.checkExchange();
        return super.getPattern();
    }

    public Object getProperty(String string) {
        this.checkExchange();
        return super.getProperty(string);
    }

    public Set<?> getPropertyNames() {
        this.checkExchange();
        return super.getPropertyNames();
    }

    public MessageExchange.Role getRole() {
        this.checkExchange();
        return super.getRole();
    }

    public QName getService() {
        this.checkExchange();
        return super.getService();
    }

    public ExchangeStatus getStatus() {
        this.checkExchange();
        return super.getStatus();
    }

    public boolean isTerminated() {
        return super.isTerminated();
    }

    public boolean isTransacted() {
        this.checkExchange();
        return super.isTransacted();
    }

    public void setEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) {
        this.checkExchange();
        super.setEndpoint(serviceEndpoint);
    }

    public void setError(Exception exception) {
        this.checkExchange();
        super.setError(exception);
    }

    public void setFault(Fault fault) throws MessagingException {
        this.checkExchange();
        super.setFault(fault);
    }

    public void setInterfaceName(QName qName) {
        this.checkExchange();
        super.setInterfaceName(qName);
    }

    public void setMessage(NormalizedMessage normalizedMessage, String string) throws MessagingException {
        this.checkExchange();
        super.setMessage(normalizedMessage, string);
    }

    public void setOperation(QName qName) {
        this.checkExchange();
        super.setOperation(qName);
    }

    public void setPersisted(boolean bl) {
        this.checkExchange();
        super.setPersisted(bl);
    }

    public void setProperty(String string, Object object) {
        this.checkExchange();
        super.setProperty(string, object);
    }

    public void setRole(MessageExchange.Role role) {
        this.checkExchange();
        super.setRole(role);
    }

    public void setService(QName qName) {
        this.checkExchange();
        super.setService(qName);
    }

    public void setStatus(ExchangeStatus exchangeStatus) throws MessagingException {
        this.checkExchange();
        super.setStatus(exchangeStatus);
    }

    public void setTerminated(boolean bl) {
        this.checkExchange();
        super.setTerminated(bl);
    }

    public void persistExchange(PersistenceService persistenceService) throws IOException, SQLException {
        if (this.messageExchange.isPersisted() || this.messageExchange.isMonitored()) {
            persistenceService.updateMessageExchange(this.messageExchange, true, null);
        } else {
            persistenceService.addMessageExchange(this.messageExchange, true, null);
        }
        this.messageExchange = null;
        this.persistenceService = persistenceService;
    }

    private void checkExchange() throws RuntimeException {
        if (this.messageExchange == null) {
            try {
                this.messageExchange = this.persistenceService.getMessageExchange(this.exchangeId);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException("Failed to retrieve Message Exchange with id '" + this.exchangeId + "' from the persistence service", sQLException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to retrieve Message Exchange with id '" + this.exchangeId + "' from the persistence service", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Failed to retrieve Message Exchange with id '" + this.exchangeId + "' from the persistence service", classNotFoundException);
            }
        }
    }
}

