/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.util;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;

public class SourcesForkerUtil {
    private static final Map<String, Map<String, InputStreamForker>> forkedStreams = new ConcurrentHashMap<String, Map<String, InputStreamForker>>();

    public static final void cleanExchangeSources(MessageExchange messageExchange) throws IOException {
        Map<String, InputStreamForker> map = forkedStreams.remove(messageExchange.getExchangeId());
        if (map != null) {
            for (InputStreamForker inputStreamForker : map.values()) {
                inputStreamForker.fork().close();
            }
        }
    }

    public static final void forkExchangeSources(MessageExchangeWrapper messageExchangeWrapper) throws MessagingException {
        Map<String, InputStreamForker> map = forkedStreams.get(messageExchangeWrapper.getExchangeId());
        if (map == null) {
            map = new HashMap<String, InputStreamForker>();
            forkedStreams.put(messageExchangeWrapper.getExchangeId(), map);
        }
        Map map2 = messageExchangeWrapper.getMessages();
        for (Map.Entry entry : map2.entrySet()) {
            StreamSource streamSource;
            String string = (String)entry.getKey();
            Source source = ((NormalizedMessage)entry.getValue()).getContent();
            if (!(source instanceof StreamSource)) continue;
            InputStreamForker inputStreamForker = map.get(string);
            if (inputStreamForker != null) {
                try {
                    inputStreamForker = new InputStreamForker(inputStreamForker.fork());
                }
                catch (IOException iOException) {
                    throw new UncheckedException((Throwable)iOException);
                }
            } else {
                streamSource = (StreamSource)source;
                InputStream inputStream = streamSource.getInputStream();
                inputStreamForker = inputStream != null ? new InputStreamForker(inputStream) : new InputStreamForker((InputStream)new ReaderInputStream(streamSource.getReader()));
            }
            map.put(string, inputStreamForker);
            try {
                streamSource = new StreamSource(inputStreamForker.fork());
            }
            catch (IOException iOException) {
                throw new UncheckedException((Throwable)iOException);
            }
            ((NormalizedMessage)entry.getValue()).setContent((Source)streamSource);
        }
    }
}

