/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.ow2.petals.jaas.GroupPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationEntry {
    private Set<GroupPrincipal> accessControlList;
    private QName service;
    private String endpoint;
    private QName operation;
    private ROLE_TYPE type = ROLE_TYPE.ADD;

    public AuthorizationEntry() {
    }

    public AuthorizationEntry(QName qName, String string, QName qName2, String string2) {
        this(qName, string, qName2, string2, ROLE_TYPE.ADD);
    }

    public AuthorizationEntry(QName qName, String string, QName qName2, String string2, ROLE_TYPE rOLE_TYPE) {
        this.service = qName;
        this.endpoint = string;
        this.operation = qName2;
        this.accessControlList = this.buildRoles(string2);
        this.type = rOLE_TYPE;
    }

    public ROLE_TYPE getType() {
        return this.type;
    }

    public void setType(ROLE_TYPE rOLE_TYPE) {
        this.type = rOLE_TYPE;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String string) {
        this.endpoint = string;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName qName) {
        if ("".equals(qName.getNamespaceURI()) && qName.getPrefix() != null && qName.getPrefix().length() > 0) {
            qName = new QName(qName.getPrefix(), qName.getLocalPart());
        }
        this.service = qName;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName qName) {
        this.operation = qName;
    }

    public Set<GroupPrincipal> getAcls() {
        return this.accessControlList;
    }

    public void setAcls(Set<GroupPrincipal> set) {
        this.accessControlList = set;
    }

    public void setRoles(String string) {
        this.accessControlList = this.buildRoles(string);
    }

    public String getRoles() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.accessControlList != null) {
            Iterator<GroupPrincipal> iterator = this.accessControlList.iterator();
            while (iterator.hasNext()) {
                GroupPrincipal groupPrincipal = iterator.next();
                stringBuffer.append(groupPrincipal);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "AuthorizationEntry[service=" + this.service + ", endpoint=" + this.endpoint + ", operation=" + this.operation + ", roles=" + this.getRoles() + "]";
    }

    private Set<GroupPrincipal> buildRoles(String string) {
        HashSet<GroupPrincipal> hashSet = new HashSet<GroupPrincipal>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            hashSet.add(new GroupPrincipal(string2));
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ROLE_TYPE {
        ADD,
        SET,
        REM;

    }
}

