/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.service;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.petals.kernel.api.service.Location;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointImpl
implements Serializable,
ServiceEndpoint {
    private static final Logger LOGGER = Logger.getLogger(ServiceEndpointImpl.class.getName());
    private static final long serialVersionUID = 3846565220895975538L;
    private transient Document description;
    private transient String stringDescription;
    private String endpointName;
    private QName serviceName;
    private Location location;
    private List<QName> interfacesName;
    private ServiceEndpoint.EndpointType type;

    public ServiceEndpointImpl() {
        this(null, null, new ArrayList<QName>(0), null, new Location(), new HashMap<String, String>());
    }

    public ServiceEndpointImpl(String string, QName qName, List<QName> list, Document document, Location location, Map<String, String> map) {
        this.endpointName = string;
        this.serviceName = qName;
        this.interfacesName = list;
        this.description = document;
        this.location = location;
    }

    public synchronized Document getDescription() {
        if (this.description == null && this.stringDescription != null) {
            try {
                this.description = XMLHelper.createDocumentFromString((String)this.stringDescription);
            }
            catch (SAXException sAXException) {
                LOGGER.log(Level.SEVERE, "Bad XML fragment can't be transformed to a DOM tree.", sAXException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Unexpected Error", iOException);
            }
        }
        return this.description;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public List<QName> getInterfacesName() {
        return this.interfacesName;
    }

    public Location getLocation() {
        return this.location;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setDescription(Document document) {
        this.description = document;
    }

    public void setEndpointName(String string) {
        this.endpointName = string;
    }

    public void setServiceName(QName qName) {
        this.serviceName = qName;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setInterfacesName(List<QName> list) {
        this.interfacesName = list;
    }

    public String toString() {
        return this.serviceName + " ->" + this.endpointName + " (" + this.getType() + "):" + this.location.getSubdomainName() + "/" + this.location.getContainerName() + "/" + this.location.getComponentName();
    }

    public ServiceEndpoint.EndpointType getType() {
        return this.type;
    }

    public void setType(ServiceEndpoint.EndpointType endpointType) {
        this.type = endpointType;
    }

    public String getStringDescription() {
        return this.stringDescription;
    }

    public void setStringDescription(String string) {
        this.stringDescription = string;
    }
}

