/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.ow2.petals.transport.platform.nio.selector.NioClient;
import org.ow2.petals.transport.platform.nio.selector.NioSelector;
import org.ow2.petals.transport.platform.nio.selector.OutputSocketChannelContext;
import org.ow2.petals.util.LoggingUtil;

public class NioClientAgent
implements NioClient {
    private final LoggingUtil log;
    private SocketChannel clientSocketChannel;
    private NioSelector selectorAgent;
    private Semaphore isDoneSignal = new Semaphore(1);
    private volatile boolean isUsable = true;
    private IOException detectedException = null;
    private OutputSocketChannelContext clientSocketChannelContext;
    private String clientSocketStr;
    private ByteArrayOutputStream bytesStream;

    public NioClientAgent(Logger logger, NioSelector nioSelector) throws IOException {
        this.log = new LoggingUtil(logger);
        this.selectorAgent = nioSelector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(String string, int n, long l) throws IOException {
        this.log.start();
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            this.clientSocketChannel = SocketChannel.open();
            this.clientSocketChannel.configureBlocking(false);
            this.clientSocketChannel.socket().setKeepAlive(true);
            this.isDoneSignal.acquire();
            if (!this.clientSocketChannel.connect(inetSocketAddress)) {
                this.selectorAgent.register(8, this.clientSocketChannel, this);
                if (!this.isDoneSignal.tryAcquire(l, TimeUnit.MILLISECONDS)) {
                    this.isDoneSignal.release();
                    this.disconnect();
                    throw new IOException("A connection timeout occurs on socket (" + inetSocketAddress + ").");
                }
                this.isDoneSignal.release();
                if (this.detectedException != null) {
                    throw this.detectedException;
                }
            } else {
                this.isDoneSignal.release();
            }
            this.clientSocketStr = this.clientSocketChannel.socket().toString();
        }
        catch (InterruptedException interruptedException) {
            this.log.warning((Object)"Connection interrupted.");
        }
        this.log.end();
    }

    public void onIsConnected(OutputSocketChannelContext outputSocketChannelContext) {
        this.clientSocketChannelContext = outputSocketChannelContext;
        this.bytesStream = new ByteArrayOutputStream();
        try {
            this.selectorAgent.register(1, this.clientSocketChannel, this.clientSocketChannelContext);
        }
        catch (Exception exception) {
            this.log.warning((Object)("An error occurs during OP_READ registration, perhaps disconnection of the remote side won't be detected (" + exception.getMessage() + ")."));
        }
        this.isDoneSignal.release();
    }

    public void onConnectionError(IOException iOException) {
        this.detectedException = iOException;
        this.isDoneSignal.release();
    }

    public void send(Object object, long l) throws IOException, InterruptedException {
        block7: {
            this.log.start();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.bytesStream);
                objectOutputStream.writeUnshared(object);
                objectOutputStream.flush();
                byte[] byArray = this.bytesStream.toByteArray();
                this.bytesStream.reset();
                if (this.clientSocketChannelContext.offer(byArray)) {
                    this.isDoneSignal.acquire();
                    this.detectedException = null;
                    this.selectorAgent.register(5, this.clientSocketChannel, this.clientSocketChannelContext);
                    if (this.isDoneSignal.tryAcquire(l, TimeUnit.MILLISECONDS)) {
                        this.isDoneSignal.release();
                        if (this.detectedException != null) {
                            throw this.detectedException;
                        }
                    } else {
                        this.isDoneSignal.release();
                        this.disconnect();
                        throw new IOException("A write timeout occurs on socket (" + this.clientSocketStr + ").");
                    }
                    if (this.detectedException != null) {
                        throw this.detectedException;
                    }
                    break block7;
                }
                throw new IOException("Unable to transmit data to the NIO selector (the queue is full).");
            }
            catch (IOException iOException) {
                this.isUsable = false;
                throw iOException;
            }
        }
        this.log.end();
    }

    public void onIsWritten() throws IOException {
        this.selectorAgent.register(1, this.clientSocketChannel, this.clientSocketChannelContext);
        this.isDoneSignal.release();
    }

    public void onWriteError(IOException iOException) throws IOException {
        this.detectedException = iOException;
        this.isDoneSignal.release();
    }

    public void onClose(SocketChannel socketChannel) {
        this.isUsable = false;
        this.log.warning((Object)("Connection closed by the server side (" + socketChannel.socket().getInetAddress() + ")."));
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            this.log.warning((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public void disconnect() throws IOException {
        this.isUsable = false;
        this.clientSocketChannel.close();
    }

    public boolean isUsable() {
        return this.isUsable;
    }
}

