/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.selector;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.ow2.petals.transport.platform.nio.selector.AbstractSocketChannelContext;
import org.ow2.petals.transport.platform.nio.selector.NioServer;
import org.ow2.petals.transport.platform.nio.selector.PipedDeserializer;

public class InputSocketChannelContext
extends AbstractSocketChannelContext {
    private final OutputStream bytesStream;
    private final PipedDeserializer deserializer;
    private NioServer nioServer;
    final byte[] headerBuffer = new byte[4];
    final ByteBuffer integerBuffer = ByteBuffer.allocateDirect(4);
    int headerRemainingBytes = 0;
    boolean isHeaderCompletlyRead = true;

    public InputSocketChannelContext(SocketChannel socketChannel, PipedDeserializer pipedDeserializer, NioServer nioServer) throws SocketException {
        super(socketChannel, socketChannel.socket().getReceiveBufferSize());
        this.deserializer = pipedDeserializer;
        this.bytesStream = pipedDeserializer.getOutputStream();
        this.nioServer = nioServer;
    }

    public void read(SelectionKey selectionKey) throws IOException {
        int n;
        this.directBuffer.clear();
        try {
            n = this.socketChannel.read(this.directBuffer);
        }
        catch (IOException iOException) {
            this.closeConnection(selectionKey);
            return;
        }
        if (n == -1) {
            this.closeConnection(selectionKey);
        } else {
            this.directBuffer.flip();
            do {
                if (!this.isHeaderCompletlyRead) {
                    if (n >= this.headerRemainingBytes) {
                        this.isHeaderCompletlyRead = true;
                        this.directBuffer.get(this.headerBuffer, 4 - this.headerRemainingBytes, this.headerRemainingBytes);
                        this.integerBuffer.clear();
                        this.integerBuffer.put(this.headerBuffer);
                        this.integerBuffer.flip();
                        this.msgExRemainingBytes = this.integerBuffer.getInt();
                        n -= this.headerRemainingBytes;
                    } else {
                        this.directBuffer.get(this.headerBuffer, 4 - this.headerRemainingBytes, n);
                        this.headerRemainingBytes -= n;
                        n = 0;
                    }
                } else if (!this.isIOPending) {
                    if (n >= 4) {
                        this.msgExRemainingBytes = this.directBuffer.getInt();
                        n -= 4;
                        this.isHeaderCompletlyRead = true;
                    } else {
                        this.isHeaderCompletlyRead = false;
                        this.headerRemainingBytes = 4 - n;
                        this.directBuffer.get(this.headerBuffer, 0, n);
                        n = 0;
                    }
                    this.isIOPending = true;
                }
                if (n <= 0) continue;
                byte[] byArray = new byte[Math.min(this.msgExRemainingBytes, n)];
                this.directBuffer.get(byArray);
                this.bytesStream.write(byArray);
                if (byArray.length == this.msgExRemainingBytes) {
                    this.endMsgExRead();
                } else {
                    this.msgExRemainingBytes -= byArray.length;
                }
                n -= byArray.length;
            } while (n > 0);
        }
    }

    private void closeConnection(SelectionKey selectionKey) throws IOException {
        System.err.println("The client has forcibly closed its connection.");
        this.socketChannel.close();
        selectionKey.cancel();
        this.nioServer.onClose(this.socketChannel);
    }

    private final void endMsgExRead() {
        this.isIOPending = false;
        this.nioServer.onRead(this.deserializer);
    }
}

