/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.kernel.ws.api.EndpointService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.to.Endpoint;
import org.ow2.petals.kernel.ws.api.to.EndpointQuery;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=EndpointService.class)})
public class EndpointServiceImpl
implements BindingController,
LifeCycleController,
EndpointService,
KernelWebService {
    private Component component;
    private LoggingUtil log;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.WS.EndpointService"));
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    public String getFcState() {
        return null;
    }

    public List<Endpoint> getEndpoints() throws PEtALSWebServiceException {
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        List<ServiceEndpoint> list = null;
        try {
            list = this.endpointRegistry.getEndpoints();
        }
        catch (RegistryException registryException) {
            this.log.warning((Object)"Can not get endpoint list", (Throwable)((Object)registryException));
            throw new PEtALSWebServiceException("Can not get endpoint list");
        }
        for (ServiceEndpoint serviceEndpoint : list) {
            Endpoint endpoint = new Endpoint();
            endpoint.setComponent(serviceEndpoint.getLocation().getComponentName());
            endpoint.setContainer(serviceEndpoint.getLocation().getContainerName());
            endpoint.setInterfaces(serviceEndpoint.getInterfaces());
            endpoint.setName(serviceEndpoint.getEndpointName());
            endpoint.setService(serviceEndpoint.getServiceName());
            endpoint.setSubDomain(serviceEndpoint.getLocation().getSubdomainName());
            try {
                endpoint.setDescription(XMLHelper.createStringFromDOMDocument((Node)serviceEndpoint.getDescription()));
            }
            catch (TransformerException transformerException) {
                this.log.warning((Object)transformerException.getMessage());
            }
            catch (PoolException poolException) {
                this.log.warning((Object)poolException.getMessage());
            }
            arrayList.add(endpoint);
        }
        return arrayList;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public List<Endpoint> query(EndpointQuery endpointQuery) throws PEtALSWebServiceException {
        if (endpointQuery == null) {
            throw new PEtALSWebServiceException("Query can not be null");
        }
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        List<ServiceEndpoint> list = null;
        String string = null;
        if (endpointQuery.getEndpoint() != null) {
            string = endpointQuery.getEndpoint().toString();
        }
        try {
            list = this.endpointRegistry.query(string, endpointQuery.getInterface(), endpointQuery.getService(), endpointQuery.getContainerName(), endpointQuery.getComponentName(), endpointQuery.getSubdomainName(), endpointQuery.getType());
        }
        catch (RegistryException registryException) {
            this.log.warning((Object)"Can not get endpoint list", (Throwable)((Object)registryException));
            throw new PEtALSWebServiceException("Can not get endpoint list");
        }
        for (ServiceEndpoint serviceEndpoint : list) {
            Endpoint endpoint = new Endpoint();
            endpoint.setComponent(serviceEndpoint.getLocation().getComponentName());
            endpoint.setContainer(serviceEndpoint.getLocation().getContainerName());
            List list2 = serviceEndpoint.getInterfacesName();
            if (list2 != null) {
                endpoint.setInterfaces(list2.toArray(new QName[list2.size()]));
            }
            endpoint.setName(serviceEndpoint.getEndpointName());
            endpoint.setService(serviceEndpoint.getServiceName());
            endpoint.setSubDomain(serviceEndpoint.getLocation().getSubdomainName());
            try {
                endpoint.setDescription(XMLHelper.createStringFromDOMDocument((Node)serviceEndpoint.getDescription()));
            }
            catch (TransformerException transformerException) {
                this.log.warning((Object)transformerException.getMessage());
            }
            catch (PoolException poolException) {
                this.log.warning((Object)poolException.getMessage());
            }
            arrayList.add(endpoint);
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("endpoint");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

