/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.ServiceAssemblyStateService;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=ServiceAssemblyStateService.class)})
public class ServiceAssemblyStateServiceImpl
implements BindingController,
LifeCycleController,
ServiceAssemblyStateService,
KernelWebService {
    private Component component;
    @Requires(name="adminService", signature=AdminService.class)
    private AdminService adminService;
    private LoggingUtil log;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.WS.ServiceAssemblyStateService"));
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public boolean isShutdown(String string) throws PEtALSWebServiceException {
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.getServiceAssemblyLifeCycle(string);
        return serviceAssemblyLifeCycle.isShutdownState();
    }

    public boolean isStarted(String string) throws PEtALSWebServiceException {
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.getServiceAssemblyLifeCycle(string);
        return serviceAssemblyLifeCycle.isStartedState();
    }

    public boolean isStopped(String string) throws PEtALSWebServiceException {
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.getServiceAssemblyLifeCycle(string);
        return serviceAssemblyLifeCycle.isStoppedState();
    }

    public String getFcState() {
        return null;
    }

    public boolean isUnknown(String string) throws PEtALSWebServiceException {
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.getServiceAssemblyLifeCycle(string);
        return serviceAssemblyLifeCycle.isUnknownState();
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Component getComponent() {
        return this.component;
    }

    private ServiceAssemblyLifeCycle getServiceAssemblyLifeCycle(String string) throws PEtALSWebServiceException {
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle == null) {
            throw new PEtALSWebServiceException("Can not find a service assembly with ID = " + string);
        }
        return serviceAssemblyLifeCycle;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("adminService")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("adminService");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("adminService")) {
            return this.adminService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("adminService")) {
            this.adminService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

