/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.api.server.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.ow2.petals.kernel.api.server.PetalsException;

public final class SystemUtil {
    public static final String ENVIRONMENT_INSTALL_PATH = "PETALS_HOME";
    public static final String PROPERTY_INSTALL_PATH = "petals.home";
    private static File petalsHome = SystemUtil.resolveInstallDirectoryFromEnvironment();

    private SystemUtil() {
    }

    public static File getPetalsInstallDirectory() {
        if (petalsHome == null) {
            throw new RuntimeException("Petals installation directory can not be found. Set a PETALS_HOME variable or use petals.home JAVA property");
        }
        return petalsHome;
    }

    private static File resolveInstallDirectoryFromEnvironment() {
        File theHome;
        File directory = null;
        String petalsHomeValue = System.getProperty(PROPERTY_INSTALL_PATH);
        if (petalsHomeValue == null || petalsHomeValue.trim().length() == 0) {
            petalsHomeValue = System.getenv(ENVIRONMENT_INSTALL_PATH);
        }
        if (petalsHomeValue != null && petalsHomeValue.trim().length() > 0 && ((theHome = new File(petalsHomeValue)).exists() || theHome.isDirectory())) {
            directory = theHome;
        }
        return directory;
    }

    private static File resolveInstallDirectoryFromFramework() throws PetalsException {
        File directory = null;
        URL url = SystemUtil.class.getProtectionDomain().getCodeSource().getLocation();
        if (url != null) {
            try {
                URI baseURI = new URI(url.toString()).resolve("..");
                directory = new File(baseURI);
            }
            catch (URISyntaxException e) {
                throw new PetalsException(e);
            }
        }
        return directory;
    }

    static {
        if (petalsHome == null) {
            try {
                petalsHome = SystemUtil.resolveInstallDirectoryFromFramework();
            }
            catch (PetalsException petalsException) {
                // empty catch block
            }
        }
    }
}

