/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.support.validator;

import spoon.aval.Validator;
import spoon.aval.annotation.structure.Type;
import spoon.aval.processing.ValidationPoint;
import spoon.processing.ProblemFixer;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeValidator
implements Validator<Type> {
    @Override
    public void check(ValidationPoint<Type> vp) {
        Class actualClass = null;
        if (vp.getProgramElement() instanceof CtTypedElement) {
            CtTypedElement typed = (CtTypedElement)vp.getProgramElement();
            actualClass = typed.getType().getActualClass();
        }
        if (vp.getProgramElement() instanceof CtType) {
            actualClass = ((CtType)vp.getProgramElement()).getActualClass();
        }
        if (actualClass == null) {
            ValidationPoint.report(Severity.ERROR, vp.getProgramElement(), "Not a type!", new ProblemFixer[0]);
            return;
        }
        if (!vp.getValAnnotation().value().isAssignableFrom(actualClass)) {
            String message = vp.getValAnnotation().message().replace("?val", vp.getValAnnotation().value().toString());
            ValidationPoint.report(vp.getValAnnotation().severity(), (CtElement)vp.getDslAnnotation(), message, vp.fixerFactory(vp.getValAnnotation().fixers()));
        }
    }
}

