/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.attributes;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.attributes.Attribute;
import org.objectweb.fractal.adl.attributes.AttributeBuilder;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.task.core.Task;
import org.objectweb.fractal.task.core.TaskMap;
import org.objectweb.fractal.task.deployment.lib.AbstractAttributeSetterTask;

public class AttributeCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public AttributeBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (AttributeBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    public void compile(List path, ComponentContainer container, TaskMap tasks, Map context) throws ADLException {
        Attributes attributes;
        if (container instanceof AttributesContainer && (attributes = ((AttributesContainer)((Object)container)).getAttributes()) != null) {
            TaskMap.TaskHole createTaskHole = tasks.getTaskHole("create", (Object)container);
            TaskMap.TaskHole startTaskHole = tasks.getTaskHole("start", (Object)container);
            Attribute[] attrs = attributes.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                try {
                    tasks.getTask("attr" + attrs[i].getName(), (Object)container);
                    continue;
                }
                catch (NoSuchElementException e) {
                    AttributeTask attributeTask = new AttributeTask(this.builder, attributes.getSignature(), attrs[i].getName(), attrs[i].getValue());
                    TaskMap.TaskHole attributeTaskHole = tasks.addTask("attr" + attrs[i].getName(), (Object)container, (Task)attributeTask);
                    attributeTask.setInstanceProviderTask(createTaskHole);
                    attributeTask.addDependency(createTaskHole, Task.PREVIOUS_TASK_ROLE, context);
                    startTaskHole.addDependency(attributeTaskHole, Task.PREVIOUS_TASK_ROLE, (Object)context);
                }
            }
        }
    }

    static class AttributeTask
    extends AbstractAttributeSetterTask {
        private AttributeBuilder builder;
        private String attributeController;
        private String name;

        public AttributeTask(AttributeBuilder builder, String attributeController, String name, String value) {
            this.builder = builder;
            this.attributeController = attributeController;
            this.name = name;
            this.setValue(value);
        }

        public void execute(Map context) throws Exception {
            Object component = this.getInstanceProviderTask().getInstance();
            this.builder.setAttribute(component, this.attributeController, this.name, (String)this.getValue(), context);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[AttributeTask(" + this.name + "," + this.getValue() + ")]";
        }
    }
}

