/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.configuration;

import java.util.Properties;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.util.configuration.ConfigurationException;
import org.objectweb.carol.util.configuration.TraceCarol;

public class Protocol {
    private String name = null;
    private Properties properties = null;
    private PortableRemoteObjectDelegate portableRemoteObjectDelegate = null;
    private String portableRemoteObjectClassName = null;
    private String initialContextFactoryClassName = null;
    private String registryClassName = null;
    private String interceptorNamePrefix = null;

    protected String getValue(String key) throws ConfigurationException {
        String s = this.properties.getProperty(key);
        if (s == null) {
            throw new ConfigurationException("Property '" + key + "' was not found in the properties object of the protocol, properties are :'" + this.properties + "'");
        }
        return s;
    }

    public Protocol(String name, Properties properties) throws ConfigurationException {
        if (name == null || "".equals(name)) {
            throw new ConfigurationException("Cannot build a protocol with null or empty name");
        }
        this.name = name;
        if (properties == null) {
            throw new ConfigurationException("Cannot build a new protocol without properties");
        }
        this.properties = properties;
        String prefixProtocol = "carol." + name + ".";
        this.portableRemoteObjectClassName = this.getValue(prefixProtocol + "PortableRemoteObjectClass");
        this.initialContextFactoryClassName = this.getValue(prefixProtocol + "context.factory");
        this.registryClassName = this.getValue(prefixProtocol + "NameServiceClass");
        this.interceptorNamePrefix = properties.getProperty("carol." + name + "." + "interceptor.pkgs");
        String interceptorValues = properties.getProperty("carol." + name + "." + "interceptors");
        if (this.interceptorNamePrefix != null && interceptorValues != null) {
            String[] values = interceptorValues.split(",");
            for (int s = 0; s < values.length; ++s) {
                String value = values[s];
                this.addInterceptor(value);
            }
        }
    }

    public void addInterceptor(String interceptorInitializer) {
        System.setProperty(this.interceptorNamePrefix + "." + interceptorInitializer, "");
        if (TraceCarol.isDebugCarol()) {
            TraceCarol.debugCarol("Setting interceptor " + this.interceptorNamePrefix + "." + interceptorInitializer + "/");
        }
    }

    public String getInitialContextFactoryClassName() {
        return this.initialContextFactoryClassName;
    }

    public String getRegistryClassName() {
        return this.registryClassName;
    }

    public PortableRemoteObjectDelegate getPortableRemoteObject() {
        if (this.portableRemoteObjectDelegate != null) {
            return this.portableRemoteObjectDelegate;
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.portableRemoteObjectClassName);
            this.portableRemoteObjectDelegate = (PortableRemoteObjectDelegate)clazz.newInstance();
        }
        catch (Exception e) {
            IllegalStateException newEx = new IllegalStateException("Cannot build PortableRemoteObjectDelegate class '" + this.portableRemoteObjectClassName + "'");
            newEx.initCause(e);
            throw newEx;
        }
        return this.portableRemoteObjectDelegate;
    }

    public String getName() {
        return this.name;
    }
}

