/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog;

import java.io.FileInputStream;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;
import org.objectweb.util.monolog.wrapper.common.Configurable;

public class TestMultipleLoggerFactory {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: TestMultipleLoggerFactory <logger factory class name A> <properties file name A> <logger factory class name B> <properties file name B> <order: A | B> ");
            System.exit(1);
        }
        LoggerFactory lfa = null;
        LoggerFactory lfb = null;
        try {
            lfa = (LoggerFactory)Class.forName(args[0]).newInstance();
            lfb = (LoggerFactory)Class.forName(args[2]).newInstance();
            Properties pa = new Properties();
            pa.load(new FileInputStream(args[1]));
            Properties pb = new Properties();
            pb.load(new FileInputStream(args[3]));
            if (args.length == 5 && args[4].equalsIgnoreCase("b")) {
                PropertiesConfAccess.load(pa, lfa, (HandlerFactory)((Object)lfa), (LevelFactory)((Object)lfa));
                ((Configurable)lfb).configure(pb);
            } else {
                PropertiesConfAccess.load(pa, lfa, (HandlerFactory)((Object)lfa), (LevelFactory)((Object)lfa));
                ((Configurable)lfb).configure(pb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Logger la = lfa.getLogger("a");
        Logger lb = lfa.getLogger("b");
        la.log(BasicLevel.WARN, (Object)"Message 1 send by the logger A");
        la.log(BasicLevel.WARN, (Object)"Message 2 send by the logger A");
        la.log(BasicLevel.WARN, (Object)"Message 3 send by the logger A");
        lb.log(BasicLevel.WARN, (Object)"Message 1 send by the logger B");
        lb.log(BasicLevel.WARN, (Object)"Message 2 send by the logger B");
        lb.log(BasicLevel.WARN, (Object)"Message 3 send by the logger B");
        la = lfa.getLogger("a.c");
        la.log(BasicLevel.WARN, (Object)"Message 1 send by the logger A.C");
        la.log(BasicLevel.WARN, (Object)"Message 2 send by the logger A.C");
        la.log(BasicLevel.WARN, (Object)"Message 3 send by the logger A.C");
        lb = lfa.getLogger("b.d");
        lb.log(BasicLevel.WARN, (Object)"Message 1 send by the logger B.D");
        lb.log(BasicLevel.WARN, (Object)"Message 2 send by the logger B.D");
        lb.log(BasicLevel.WARN, (Object)"Message 3 send by the logger B.D");
    }
}

