/*
 * Decompiled with CFR 0.152.
 */
package spoon.processing;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import spoon.processing.Environment;
import spoon.processing.Processor;
import spoon.processing.ProcessorProperties;
import spoon.processing.Property;
import spoon.processing.Severity;
import spoon.processing.TraversalStrategy;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.support.util.RtHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessor<E extends CtElement>
implements Processor<E> {
    Factory factory;
    Set<Class<? extends CtElement>> processedElementTypes = new HashSet<Class<? extends CtElement>>();

    public AbstractProcessor() {
        for (Method m : this.getClass().getMethods()) {
            Class<?> c;
            if (!m.getName().equals("process") || m.getParameterTypes().length != 1 || CtElement.class == (c = m.getParameterTypes()[0])) continue;
            this.addProcessedElementType(c);
        }
        if (this.processedElementTypes.isEmpty()) {
            this.addProcessedElementType(CtElement.class);
        }
    }

    protected void addProcessedElementType(Class<? extends CtElement> elementType) {
        this.processedElementTypes.add(elementType);
    }

    protected void clearProcessedElementType() {
        this.processedElementTypes.clear();
    }

    @Override
    public Environment getEnvironment() {
        return this.getFactory().getEnvironment();
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public Set<Class<? extends CtElement>> getProcessedElementTypes() {
        return this.processedElementTypes;
    }

    public static ProcessorProperties loadProperties(Processor p) {
        ProcessorProperties props = null;
        try {
            props = p.getFactory().getEnvironment().getProcessorProperties(p.getClass().getName());
        }
        catch (FileNotFoundException e) {
            p.getFactory().getEnvironment().debugMessage("property file not found for processor '" + p.getClass().getName() + "'");
        }
        catch (IOException e) {
            p.getFactory().getEnvironment().report(p, Severity.ERROR, "wrong properties file format for processor '" + p.getClass().getName() + "'");
            e.printStackTrace();
        }
        catch (Exception e) {
            p.getFactory().getEnvironment().report(p, Severity.ERROR, "unable to get properties for processor '" + p.getClass().getName() + "': " + e.getMessage());
            e.printStackTrace();
        }
        return props;
    }

    @Override
    public TraversalStrategy getTraversalStrategy() {
        return TraversalStrategy.PRE_ORDER;
    }

    @Override
    public void init() {
    }

    @Override
    public final void initProperties(ProcessorProperties properties) {
        AbstractProcessor.initProperties(this, properties);
    }

    @Override
    public boolean isToBeProcessed(E candidate) {
        return !(candidate instanceof CtClass) || !this.factory.Template().getAll().containsKey(((CtClass)candidate).getQualifiedName());
    }

    public static void initProperties(Processor p, ProcessorProperties properties) {
        if (properties != null) {
            for (Field f : RtHelper.getAllFields(p.getClass())) {
                if (!f.isAnnotationPresent(Property.class)) continue;
                Object obj = properties.get(f.getType(), f.getName());
                if (obj != null) {
                    f.setAccessible(true);
                    try {
                        f.set(p, obj);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                p.getFactory().getEnvironment().report(p, Severity.WARNING, "No value found for property '" + f.getName() + "' in processor " + p.getClass().getName());
            }
        }
    }

    @Override
    public final void process() {
    }

    @Override
    public void processingDone() {
    }

    protected void removeProcessedElementType(Class<? extends CtElement> elementType) {
        this.processedElementTypes.remove(elementType);
    }

    @Override
    public final void setFactory(Factory factory) {
        this.factory = factory;
    }
}

