/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CompilationUnit;
import spoon.reflect.factory.SubFactory;

public class CompilationUnitFactory
extends SubFactory {
    private static final long serialVersionUID = 1L;
    Map<String, CompilationUnit> compilationUnits = new TreeMap<String, CompilationUnit>();

    public CompilationUnitFactory(Factory factory) {
        super(factory);
    }

    public CompilationUnit create() {
        CompilationUnit cu = this.factory.Core().createCompilationUnit();
        return cu;
    }

    public CompilationUnit create(String filePath) {
        CompilationUnit cu = this.compilationUnits.get(filePath);
        if (cu == null) {
            if ("".equals(filePath)) {
                cu = this.factory.Core().createVirtualCompilationUnit();
                return cu;
            }
            cu = this.factory.Core().createCompilationUnit();
            cu.setFile(new File(filePath));
            this.compilationUnits.put(filePath, cu);
        }
        return cu;
    }
}

