/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.eval.SymbolicEvaluationPath;
import spoon.reflect.eval.SymbolicEvaluator;
import spoon.reflect.eval.SymbolicInstance;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.reflect.eval.VisitorPartialEvaluator;
import spoon.support.reflect.eval.VisitorSymbolicEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvalFactory
extends SubFactory {
    private static final long serialVersionUID = 1L;

    public EvalFactory(Factory factory) {
        super(factory);
    }

    public PartialEvaluator createPartialEvaluator() {
        return new VisitorPartialEvaluator();
    }

    public SymbolicEvaluator createSymbolicEvaluator() {
        return new VisitorSymbolicEvaluator();
    }

    public <T> SymbolicInstance<T> createSymbolicInstance(SymbolicEvaluator evaluator, CtTypeReference<T> concreteType, boolean isType) {
        return new SymbolicInstance<T>(evaluator, concreteType, isType);
    }

    public Map<CtMethod, List<SymbolicEvaluationPath>> createEvaluationPaths(Collection<CtMethod> entryPoints) {
        HashMap<CtMethod, List<SymbolicEvaluationPath>> paths = new HashMap<CtMethod, List<SymbolicEvaluationPath>>();
        for (CtMethod m : entryPoints) {
            SymbolicEvaluator evaluator = this.createSymbolicEvaluator();
            ArrayList<SymbolicInstance> args = new ArrayList<SymbolicInstance>();
            for (CtParameter<?> p : m.getParameters()) {
                SymbolicInstance arg = this.createSymbolicInstance(evaluator, p.getType(), false);
                evaluator.getHeap().store(arg);
                args.add(arg);
            }
            SymbolicInstance target = this.createSymbolicInstance(evaluator, m.getDeclaringType().getReference(), m.getModifiers().contains((Object)ModifierKind.STATIC));
            CtType<?> targetType = m.getDeclaringType();
            for (CtField<?> field : targetType.getFields()) {
                if (!field.getModifiers().contains((Object)ModifierKind.STATIC) && m.getModifiers().contains((Object)ModifierKind.STATIC)) continue;
                CtFieldReference<?> fref = field.getReference();
                SymbolicInstance si = this.createSymbolicInstance(evaluator, fref.getType(), false);
                target.setFieldValue(evaluator.getHeap(), fref, si);
            }
            evaluator.getHeap().store(target);
            try {
                evaluator.invoke(target, m, args);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            paths.put(m, evaluator.getPaths());
        }
        return paths;
    }
}

