/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.processing.Environment;
import spoon.reflect.declaration.CompilationUnit;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.SourceCodeFragment;
import spoon.reflect.visitor.JavaPrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentDrivenJavaPrettyPrinter
implements JavaPrettyPrinter {
    Map<Integer, Integer> lineNumberMapping = new HashMap<Integer, Integer>();
    Environment env;
    CompilationUnit compilationUnit;

    private void addjustFragments(List<SourceCodeFragment> fragments) {
        int i = 0;
        for (SourceCodeFragment f : fragments) {
            for (int j = i + 1; j < fragments.size(); ++j) {
                fragments.get((int)j).position += f.code.length() - f.replacementLength;
            }
            ++i;
        }
    }

    @Override
    public StringBuffer getResult() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.compilationUnit.getOriginalSourceCode());
        ArrayList<SourceCodeFragment> fragments = new ArrayList<SourceCodeFragment>();
        if (this.compilationUnit.getSourceCodeFraments() != null) {
            for (SourceCodeFragment f : this.compilationUnit.getSourceCodeFraments()) {
                fragments.add(new SourceCodeFragment(f.position, f.code, f.replacementLength));
            }
        }
        this.addjustFragments(fragments);
        for (SourceCodeFragment f : fragments) {
            sb.replace(f.position, f.position + f.replacementLength, f.code);
        }
        return sb;
    }

    @Override
    public String getPackageDeclaration() {
        return "";
    }

    public FragmentDrivenJavaPrettyPrinter(Environment env, CompilationUnit compilationUnit) throws Exception {
        this.env = env;
        this.compilationUnit = compilationUnit;
    }

    @Override
    public void calculate(List<CtSimpleType<?>> types) {
    }

    @Override
    public Map<Integer, Integer> getLineNumberMapping() {
        return this.lineNumberMapping;
    }
}

