/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.builder;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.util.Util;
import spoon.reflect.Factory;
import spoon.support.builder.CtFile;
import spoon.support.builder.JDTTreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTCompiler
extends Main
implements ICompilerRequestor {
    public static int JAVA_COMPLIANCE = 5;
    boolean success = true;
    Compiler batchCompiler;
    PrintWriter out;
    INameEnvironment environment = null;
    List<CategorizedProblem[]> probs;

    public boolean compileSrc(Factory f, List<CtFile> files) throws Exception {
        if (files.isEmpty()) {
            return true;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-1." + JAVA_COMPLIANCE);
        args.add("-preserveAllLocals");
        args.add("-enableJavadoc");
        args.add("-noExit");
        args.add(f.getEnvironment().getSourcePath());
        this.configure(args.toArray(new String[0]));
        CompilationUnitDeclaration[] units = this.getUnits(files, f);
        JDTTreeBuilder builder = new JDTTreeBuilder(f);
        for (CompilationUnitDeclaration unit : units) {
            try {
                unit.traverse((ASTVisitor)builder, unit.scope);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.success;
    }

    public boolean compileTemplate(Factory f, List<CtFile> streams) throws Exception {
        if (streams.isEmpty()) {
            return true;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-1." + JAVA_COMPLIANCE);
        args.add("-preserveAllLocals");
        args.add("-enableJavadoc");
        args.add("-noExit");
        args.add("-nowarn");
        args.add(".");
        this.configure(args.toArray(new String[0]));
        CompilationUnitDeclaration[] units = this.getUnits(streams, f);
        JDTTreeBuilder builder = new JDTTreeBuilder(f);
        builder.template = true;
        for (CompilationUnitDeclaration unit : units) {
            unit.traverse((ASTVisitor)builder, unit.scope);
        }
        return this.success;
    }

    public JDTCompiler(PrintWriter outWriter, PrintWriter errWriter) {
        super(outWriter, errWriter, false);
    }

    public JDTCompiler() {
        super(new PrintWriter(System.out), new PrintWriter(System.err), false);
    }

    public CompilationUnit[] getCompilationUnits(List<CtFile> streams) throws Exception {
        CompilationUnit[] units = new CompilationUnit[streams.size()];
        int i = 0;
        for (CtFile stream : streams) {
            InputStream in = stream.getContent();
            units[i] = new CompilationUnit(Util.getInputStreamAsCharArray((InputStream)in, (int)-1, null), stream.getPath(), null);
            in.close();
            ++i;
        }
        return units;
    }

    public void setEnvironment(INameEnvironment environment) {
        this.environment = environment;
    }

    public CompilationUnitDeclaration[] getUnits(List<CtFile> streams, Factory f) throws Exception {
        this.startTime = System.currentTimeMillis();
        INameEnvironment environment = this.environment;
        if (environment == null) {
            environment = this.getLibraryAccess();
        }
        this.batchCompiler = new Compiler(environment, this.getHandlingPolicy(), this.options, this, this.getProblemFactory(), this.out, false);
        return this.batchCompiler.compileUnits(this.getCompilationUnits(streams));
    }

    public List<CategorizedProblem[]> getProbs() {
        if (this.probs == null) {
            this.probs = new ArrayList<CategorizedProblem[]>();
        }
        return this.probs;
    }

    public void acceptResult(CompilationResult result) {
        if (result.hasErrors()) {
            System.err.println(result);
            this.getProbs().add(result.problems);
            this.success = false;
        }
    }

    class Compiler
    extends org.eclipse.jdt.internal.compiler.Compiler {
        public Compiler(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory, PrintWriter out, boolean statementsRecovery) {
            super(environment, policy, settings, requestor, problemFactory, statementsRecovery);
        }

        public CompilationUnitDeclaration[] compileUnits(CompilationUnit[] sourceUnits) {
            CompilationUnitDeclaration unit = null;
            this.beginToCompile((ICompilationUnit[])sourceUnits);
            for (int i = 0; i < this.totalUnits; ++i) {
                unit = this.unitsToProcess[i];
                this.parser.getMethodBodies(unit);
                if (unit.scope != null) {
                    unit.scope.faultInTypes();
                }
                if (unit.scope != null) {
                    unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                unit.resolve();
                unit.analyseCode();
                this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            }
            return this.unitsToProcess;
        }
    }
}

