/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import spoon.processing.FactoryAccessor;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CompilationUnit;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.SourceCodeFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitImpl
implements CompilationUnit,
FactoryAccessor {
    Factory factory;
    List<CtSimpleType<?>> declaredTypes = new ArrayList();
    File file;
    List<SourceCodeFragment> fragments;
    String originalSourceCode;

    @Override
    public List<CtSimpleType<?>> getDeclaredTypes() {
        return this.declaredTypes;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public CtSimpleType<?> getMainType() {
        if (this.getFile() == null) {
            return this.getDeclaredTypes().get(0);
        }
        for (CtSimpleType<?> t : this.getDeclaredTypes()) {
            String name = this.getFile().getName();
            name = name.substring(0, name.lastIndexOf("."));
            if (!t.getSimpleName().equals(name)) continue;
            return t;
        }
        throw new RuntimeException("inconsistent compilation unit: '" + this.file + "': declared types are " + this.getDeclaredTypes());
    }

    @Override
    public void setDeclaredTypes(List<CtSimpleType<?>> types) {
        this.declaredTypes = types;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void addSourceCodeFragment(SourceCodeFragment fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<SourceCodeFragment>();
        }
        int i = 0;
        for (SourceCodeFragment f : this.fragments) {
            if (fragment.position <= f.position) break;
            ++i;
        }
        this.fragments.add(i, fragment);
    }

    @Override
    public List<SourceCodeFragment> getSourceCodeFraments() {
        return this.fragments;
    }

    @Override
    public String getOriginalSourceCode() {
        try {
            if (this.originalSourceCode == null) {
                FileInputStream s = new FileInputStream(this.getFile());
                byte[] elementBytes = new byte[s.available()];
                s.read(elementBytes);
                s.close();
                this.originalSourceCode = new String(elementBytes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.originalSourceCode;
    }

    @Override
    public int beginOfLineIndex(int index) {
        int cur;
        for (cur = index; cur >= 0 && this.getOriginalSourceCode().charAt(cur) != '\n'; --cur) {
        }
        return cur + 1;
    }

    @Override
    public int nextLineIndex(int index) {
        int cur;
        for (cur = index; cur < this.getOriginalSourceCode().length() && this.getOriginalSourceCode().charAt(cur) != '\n'; ++cur) {
        }
        return cur + 1;
    }

    @Override
    public int getTabCount(int index) {
        int tabCount = 0;
        int whiteSpaceCount = 0;
        for (int cur = index; cur < this.getOriginalSourceCode().length() && (this.getOriginalSourceCode().charAt(cur) == ' ' || this.getOriginalSourceCode().charAt(cur) == '\t'); ++cur) {
            if (this.getOriginalSourceCode().charAt(cur) == '\t') {
                ++tabCount;
            }
            if (this.getOriginalSourceCode().charAt(cur) != ' ') continue;
            ++whiteSpaceCount;
        }
        return tabCount += whiteSpaceCount / this.getFactory().getEnvironment().getTabulationSize();
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }
}

