/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.database;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.naming.CompositeName;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.registry.database.RegistryClient;
import org.ow2.petals.util.LoggingUtil;
import org.postgresql.Driver;

public class PostgreSqlClient
extends RegistryClient {
    private static final String getBoundObjectsSql = new StringBuffer("SELECT JNDI_BIND.NAME, JNDI_BIND.OBJECT ").append("FROM JNDI_CONTEXT INNER JOIN JNDI_BIND ").append("ON JNDI_CONTEXT.CONTEXT_ID = JNDI_BIND.CONTEXT_ID ").append("WHERE JNDI_CONTEXT.CONTEXT = ? ").toString();
    private static final String getBoundSubContextSql = new StringBuffer("SELECT JNDI_CONTEXT.CONTEXT ").append("FROM JNDI_CONTEXT ").append("WHERE JNDI_CONTEXT.CONTEXT ~ ? ").toString();

    public PostgreSqlClient(String connectionUrl, String username, String password, int connectionPoolSize, int batchSize, boolean checkTables, LoggingUtil log) throws NamingException {
        super(connectionUrl, username, password, connectionPoolSize, batchSize, checkTables, log);
        this.establishConnection();
        if (checkTables) {
            this.checkTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection() throws NamingException {
        RegistryClient.ClientKey key = new RegistryClient.ClientKey(this, this.connectionUrl, this.username, this.password);
        ConcurrentMap concurrentMap = DATASOURCES;
        synchronized (concurrentMap) {
            this.dataSource = (DataSource)DATASOURCES.get(key);
            if (this.dataSource == null) {
                try {
                    DriverManager.registerDriver((java.sql.Driver)new Driver());
                }
                catch (SQLException e2) {
                    NamingException nex = new NamingException("PostgreSQL JDBC Driver registration failed:" + e2.getMessage());
                    nex.setRootCause(e2);
                    throw nex;
                }
                GenericObjectPool connectionPool = new GenericObjectPool(null);
                connectionPool.setMaxActive(this.connectionPoolSize);
                DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.connectionUrl, this.username, this.password);
                PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, false);
                this.dataSource = new PoolingDataSource((ObjectPool)connectionPool);
                DATASOURCES.put(key, this.dataSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTables() throws NamingException {
        block14: {
            try {
                Connection jdbcConnection = this.dataSource.getConnection();
                try {
                    boolean isStructureCreated;
                    Statement stCheck = jdbcConnection.createStatement();
                    try {
                        stCheck.executeQuery("SELECT 1 FROM JNDI_CONTEXT");
                        isStructureCreated = true;
                    }
                    catch (SQLException e) {
                        isStructureCreated = false;
                    }
                    finally {
                        stCheck.close();
                    }
                    jdbcConnection.commit();
                    if (isStructureCreated) break block14;
                    this.log.info((Object)"Creating database structure");
                    Statement stInit = jdbcConnection.createStatement();
                    try {
                        this.log.debug((Object)"Creating table JNDI_CONTEXT");
                        stInit.executeUpdate("CREATE TABLE JNDI_CONTEXT (CONTEXT_ID SERIAL NOT NULL, CONTEXT VARCHAR(1024) NOT NULL, CONSTRAINT CONTEXT_PK PRIMARY KEY (CONTEXT_ID))");
                        this.log.debug((Object)"Creating index on table JNDI_CONTEXT");
                        stInit.executeUpdate("CREATE UNIQUE INDEX CTX_CTXNAME ON JNDI_CONTEXT (CONTEXT)");
                        this.log.debug((Object)"Creating table JNDI_BIND");
                        stInit.executeUpdate("CREATE TABLE JNDI_BIND (CONTEXT_ID BIGINT NOT NULL, NAME VARCHAR(512) NOT NULL, OBJECT BYTEA NOT NULL, CONSTRAINT BINDING_PK PRIMARY KEY (CONTEXT_ID, NAME))");
                        this.log.debug((Object)"Creating reference constraint");
                        stInit.executeUpdate("ALTER TABLE JNDI_BIND ADD CONSTRAINT FK_CONTEXT FOREIGN KEY(CONTEXT_ID) REFERENCES JNDI_CONTEXT(CONTEXT_ID)");
                        this.log.debug((Object)"Creating initial context in JNDI_CONTEXT");
                        stInit.executeUpdate("INSERT INTO JNDI_CONTEXT (CONTEXT) VALUES ('')");
                        this.log.info((Object)"Database structure created");
                    }
                    finally {
                        stInit.close();
                    }
                    jdbcConnection.commit();
                }
                finally {
                    jdbcConnection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                NamingException nex = new NamingException(e.getMessage());
                nex.setRootCause(e);
                throw nex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> list(CompositeName contextName) throws NameNotFoundException, NamingException {
        Map<String, Object> map;
        String contextNameStr = contextName.toString();
        Connection jdbcConnection = this.dataSource.getConnection();
        try {
            jdbcConnection.setAutoCommit(false);
            Map<String, Object> namedObjects = this.getBoundObjects(contextNameStr, jdbcConnection);
            if (namedObjects.isEmpty() && !this.isContextExist(contextNameStr, jdbcConnection)) {
                throw new NameNotFoundException(contextName + " does not exist.");
            }
            jdbcConnection.commit();
            map = namedObjects;
        }
        catch (Throwable throwable) {
            try {
                jdbcConnection.rollback();
                jdbcConnection.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new NamingException(e.getMessage());
            }
            catch (IOException e) {
                throw new NamingException(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new NamingException(e.getMessage());
            }
        }
        jdbcConnection.rollback();
        jdbcConnection.close();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getBoundObjects(String contextName, Connection jdbcConnection) throws SQLException, IOException, ClassNotFoundException {
        HashMap<String, Object> namedObjects = new HashMap<String, Object>(this.batchSize);
        PreparedStatement pstGetBoundObject = jdbcConnection.prepareStatement(getBoundObjectsSql);
        PreparedStatement pstGetBoundSubContext = jdbcConnection.prepareStatement(getBoundSubContextSql);
        try {
            HashMap<String, Object> hashMap;
            pstGetBoundObject.setString(1, contextName);
            pstGetBoundObject.setFetchSize(this.batchSize);
            ResultSet rs = pstGetBoundObject.executeQuery();
            try {
                while (rs.next()) {
                    namedObjects.put(rs.getString(1), RegistryClient.readObject(rs, 2));
                }
            }
            finally {
                rs.close();
            }
            String regexp = contextName == null || contextName.length() == 0 ? "^[^/]+$" : "^" + contextName + "/{1}";
            pstGetBoundSubContext.setString(1, regexp);
            pstGetBoundSubContext.setFetchSize(this.batchSize);
            ResultSet rs2 = pstGetBoundSubContext.executeQuery();
            try {
                if (contextName == null || contextName.length() == 0) {
                    while (rs2.next()) {
                        namedObjects.put(rs2.getString(1), null);
                    }
                } else {
                    while (rs2.next()) {
                        String fullSubContextName = rs2.getString(1);
                        namedObjects.put(fullSubContextName.substring(contextName.length() + 1), null);
                    }
                }
                hashMap = namedObjects;
            }
            catch (Throwable throwable) {
                rs2.close();
                throw throwable;
            }
            rs2.close();
            return hashMap;
        }
        finally {
            pstGetBoundObject.close();
            pstGetBoundSubContext.close();
        }
    }
}

