/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.database;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.ow2.petals.registry.database.RegistryContextImpl;
import org.ow2.petals.util.LoggingUtil;

public class RegistryInitialContextFactory
implements InitialContextFactory {
    private static final String POOLSIZE = "java.naming.poolsize";
    protected static final String DEFAULT_USERNAME = "sa";
    protected static final String DEFAULT_PASSWORD = "";
    protected static final int DEFAULT_POOLSIZE = 5;
    protected static final int DEFAULT_BATCHSIZE = 10;
    private static final String JAVA_NAMING_FACTORY_LOGGER = "java.naming.factory.logger";

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        LoggingUtil log = (LoggingUtil)environment.get(JAVA_NAMING_FACTORY_LOGGER);
        log.info((Object)"Initializing a PostgreSQL initial context");
        String urlStr = (String)environment.get("java.naming.provider.url");
        try {
            new URI(urlStr);
        }
        catch (URISyntaxException e) {
            NamingException nex = new NamingException(e.getMessage());
            nex.setRootCause(e);
            throw nex;
        }
        log.info((Object)("  - PostgreSQL connection URL: " + urlStr));
        String username = (String)environment.get("java.naming.security.principal");
        if (username == null || username.length() == 0) {
            username = DEFAULT_USERNAME;
        }
        log.info((Object)("  - PostgreSQL connection username: " + username));
        String password = (String)environment.get("java.naming.security.credentials");
        if (password == null || password.length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        String connectionPoolSizeStr = (String)environment.get(POOLSIZE);
        int connectionPoolSize = 5;
        if (connectionPoolSizeStr != null && connectionPoolSizeStr.length() != 0) {
            connectionPoolSize = Integer.parseInt(connectionPoolSizeStr);
        }
        log.info((Object)("  - PostgreSQL connection pool size: " + connectionPoolSize));
        String batchsizeStr = (String)environment.get("java.naming.batchsize");
        int batchSize = 10;
        if (batchsizeStr != null && batchsizeStr.length() != 0) {
            batchSize = Integer.parseInt(batchsizeStr);
        }
        log.info((Object)("  - PostgreSQL connection batchsize: " + batchSize));
        log.info((Object)"PostgreSQL initial context initialized.");
        return new RegistryContextImpl(urlStr, username, password, connectionPoolSize, batchSize, (LoggingUtil)environment.get(JAVA_NAMING_FACTORY_LOGGER));
    }
}

