/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.asm.CodeGenerator;
import org.objectweb.fractal.julia.asm.InterceptorClassGenerator;
import org.objectweb.fractal.julia.asm.InterceptorCodeAdapter;

public abstract class AbstractCodeGenerator
implements Opcodes,
CodeGenerator {
    public int init(InterceptorClassGenerator icg) {
        return 0;
    }

    public void generateInitCode(MethodVisitor cv) throws ClassGenerationException {
    }

    public MethodVisitor generateInterceptionCode(Method m, MethodVisitor cv) throws ClassGenerationException {
        if (this.intercept(m)) {
            return new SimpleInterceptorCodeAdapter(cv, m);
        }
        return cv;
    }

    public void generateCloneCode(MethodVisitor cv) throws ClassGenerationException {
    }

    public void close() {
    }

    protected boolean intercept(Method m) {
        return true;
    }

    protected int getInterceptionType(Method m) {
        return 1;
    }

    protected int getInterceptionCodeFormals(Method m) {
        return 0;
    }

    protected abstract void generateInterceptionCodeBlock(Method var1, boolean var2, MethodVisitor var3, int var4);

    public List getImplementedInterfaces() throws ClassGenerationException {
        return new ArrayList();
    }

    class SimpleInterceptorCodeAdapter
    extends InterceptorCodeAdapter {
        private int interceptionType;
        private Label tryLabel;
        private Label catchLabel;

        public SimpleInterceptorCodeAdapter(MethodVisitor cv, Method m) {
            super(cv, m, AbstractCodeGenerator.this.getInterceptionCodeFormals(m) + (AbstractCodeGenerator.this.getInterceptionType(m) == 2 ? 2 : 0), AbstractCodeGenerator.this.getInterceptionType(m));
            this.interceptionType = AbstractCodeGenerator.this.getInterceptionType(m);
            if (this.interceptionType == 2) {
                this.tryLabel = new Label();
                this.catchLabel = new Label();
                AbstractCodeGenerator.this.generateInterceptionCodeBlock(m, true, this.mv, this.nbFormals + 2);
                this.mv.visitLabel(this.tryLabel);
            } else {
                AbstractCodeGenerator.this.generateInterceptionCodeBlock(m, true, this.mv, this.nbFormals);
            }
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (this.interceptionType == 1) {
                this.visitLabel(this.postBlockLabel);
                AbstractCodeGenerator.this.generateInterceptionCodeBlock(this.m, false, this.mv, this.nbFormals);
                this.generateReturnCode();
            } else if (this.interceptionType == 2) {
                this.mv.visitLabel(this.catchLabel);
                this.mv.visitVarInsn(58, this.nbFormals + 1);
                this.mv.visitJumpInsn(168, this.postBlockLabel);
                this.mv.visitVarInsn(25, this.nbFormals + 1);
                this.mv.visitInsn(191);
                this.mv.visitLabel(this.postBlockLabel);
                this.mv.visitVarInsn(58, this.nbFormals);
                AbstractCodeGenerator.this.generateInterceptionCodeBlock(this.m, false, this.mv, this.nbFormals + 2);
                this.mv.visitVarInsn(169, this.nbFormals);
                this.mv.visitTryCatchBlock(this.tryLabel, this.catchLabel, this.catchLabel, null);
            }
            this.mv.visitMaxs(maxStack, maxLocals);
        }
    }
}

