/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.eval;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.eval.SymbolicEvaluator;
import spoon.reflect.eval.SymbolicHeap;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.support.util.RtHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolicInstance<T> {
    static long id = 0L;
    private String symbolName = null;
    private boolean isExternal = false;
    private CtTypeReference<T> concreteType;
    private Map<CtVariableReference, String> fields = new TreeMap<CtVariableReference, String>();

    private static long getNextId() {
        return id++;
    }

    public static void resetIds() {
        id = 0L;
    }

    public static String getSymbolId(CtTypeReference concreteType, String name) {
        CtTypeReference t = concreteType;
        if (name != null) {
            return t.getQualifiedName() + "$" + name;
        }
        return t.getQualifiedName();
    }

    public String getId() {
        return SymbolicInstance.getSymbolId(this.concreteType, this.symbolName);
    }

    public boolean equals(Object obj) {
        SymbolicInstance i = (SymbolicInstance)obj;
        boolean b = this.concreteType.equals(i.concreteType) && ((Object)this.fields).equals(i.fields) && this.isExternal == i.isExternal;
        return b;
    }

    public SymbolicInstance(SymbolicEvaluator evaluator, CtTypeReference<T> concreteType, boolean isType) {
        this.concreteType = concreteType;
        CtSimpleType<T> type = concreteType.getDeclaration();
        if (!concreteType.isPrimitive() && type != null) {
            for (CtFieldReference fr : concreteType.getAllFields()) {
                SymbolicInstance r;
                CtField f = fr.getDeclaration();
                if (f == null) continue;
                if (isType && f.hasModifier(ModifierKind.STATIC)) {
                    r = evaluator.evaluate(f.getDefaultExpression());
                    this.fields.put(fr, r == null ? null : r.getId());
                }
                if (isType || f.hasModifier(ModifierKind.STATIC)) continue;
                r = evaluator.evaluate(f.getDefaultExpression());
                this.fields.put(fr, r == null ? null : r.getId());
            }
        } else {
            this.isExternal = true;
            if (!isType) {
                for (CtTypeReference t : evaluator.getStatefullExternals()) {
                    if (!t.isAssignableFrom(concreteType)) continue;
                    for (Method m : RtHelper.getAllMethods(concreteType.getActualClass())) {
                        if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0) continue;
                        CtFieldReference<?> f = concreteType.getFactory().Field().createReference(concreteType, concreteType.getFactory().Type().createReference(m.getReturnType()), m.getName().substring(3));
                        this.fields.put(f, null);
                    }
                }
            }
        }
        this.symbolName = isType ? "type" : "" + SymbolicInstance.getNextId();
    }

    public boolean isStateful() {
        return !this.fields.isEmpty();
    }

    public CtTypeReference<T> getConcreteType() {
        return this.concreteType;
    }

    public String getFieldValue(CtVariableReference<?> fref) {
        return this.fields.get(fref);
    }

    public String getFieldValue(String fname) {
        for (CtVariableReference v : this.fields.keySet()) {
            if (!v.getSimpleName().equals(fname)) continue;
            return this.fields.get(v);
        }
        return null;
    }

    public void setFieldValue(SymbolicHeap heap, CtVariableReference<?> fref, SymbolicInstance value) {
        if (!this.fields.containsKey(fref)) {
            throw new RuntimeException("unknown field '" + fref + "' for target " + this);
        }
        this.fields.put(fref, value.getId());
        heap.store(value);
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public String toString() {
        return "#" + this.getId() + this.fields + "#";
    }

    public SymbolicInstance<T> getClone() {
        if (!this.isStateful()) {
            return this;
        }
        return new SymbolicInstance<T>(this);
    }

    public SymbolicInstance(SymbolicInstance<T> i) {
        this.concreteType = i.concreteType;
        this.isExternal = i.isExternal;
        this.symbolName = i.symbolName;
        this.fields.putAll(i.fields);
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public Map<CtVariableReference, String> getFields() {
        return this.fields;
    }
}

