/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import spoon.processing.AbstractProcessor;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.processing.Severity;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtElement;
import spoon.support.util.Timer;
import spoon.support.visitor.ProcessingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueProcessingManager
implements ProcessingManager {
    Processor<?> current;
    Factory factory;
    Queue<Processor> processors;
    ProcessingVisitor visitor;

    public QueueProcessingManager(Factory factory) {
        this.setFactory(factory);
    }

    @Override
    public void addProcessor(Class<? extends Processor> type) {
        try {
            Processor p = type.newInstance();
            this.addProcessor(p);
        }
        catch (Exception e) {
            this.factory.getEnvironment().report(null, Severity.ERROR, "Unable to instantiate processor \"" + type.getName() + "\" - Your processor should have a constructor with no arguments");
        }
    }

    @Override
    public boolean addProcessor(Processor<?> p) {
        p.setFactory(this.getFactory());
        return this.getProcessors().add(p);
    }

    @Override
    public void addProcessor(String qualifiedName) {
        try {
            this.addProcessor(Class.forName(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            this.factory.getEnvironment().report(null, Severity.ERROR, "Unable to load processor \"" + qualifiedName + "\" - Check your classpath");
        }
    }

    @Override
    public Processor<?> getCurrentProcessor() {
        return this.current;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    public Queue<Processor> getProcessors() {
        if (this.processors == null) {
            this.processors = new LinkedList<Processor>();
        }
        return this.processors;
    }

    protected ProcessingVisitor getVisitor() {
        if (this.visitor == null) {
            this.visitor = new ProcessingVisitor(this.getFactory());
        }
        return this.visitor;
    }

    @Override
    public boolean isToBeApplied(Class<? extends Processor> type) {
        for (Processor p : this.getProcessors()) {
            if (p.getClass() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process() {
        Timer.start("process");
        this.process(this.getFactory().Package().getAllRoots());
        Timer.stop("process");
    }

    @Override
    public void process(Collection<? extends CtElement> elements) {
        Processor p;
        while ((p = (Processor)this.getProcessors().poll()) != null) {
            if (this.getFactory().getEnvironment().isVerbose()) {
                this.getFactory().getEnvironment().reportProgressMessage(p.getClass().getName());
            }
            this.current = p;
            p.initProperties(AbstractProcessor.loadProperties(p));
            p.init();
            p.process();
            for (CtElement ctElement : new ArrayList<CtElement>(elements)) {
                this.process(ctElement, p);
            }
            p.processingDone();
        }
    }

    @Override
    public void process(CtElement element) {
        Processor p;
        while ((p = (Processor)this.getProcessors().poll()) != null) {
            this.current = p;
            p.init();
            p.process();
            this.process(element, p);
            p.processingDone();
        }
    }

    protected void process(CtElement element, Processor<?> processor) {
        this.getVisitor().setProcessor(processor);
        this.getVisitor().scan(element);
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
        factory.getEnvironment().setManager(this);
    }
}

