/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.builder.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import spoon.support.builder.CtFile;
import spoon.support.builder.CtFolder;
import spoon.support.builder.FileFactory;
import spoon.support.builder.support.CtFileFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtFolderFile
implements CtFolder {
    File file;
    List<CtFile> files;
    List<CtFolder> subFolders;

    public CtFolderFile(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException("Not a directory");
        }
        this.file = file;
    }

    @Override
    public List<CtFile> getAllFiles() {
        ArrayList<CtFile> all = new ArrayList<CtFile>(this.getFiles());
        for (CtFolder f : this.getSubFolder()) {
            all.addAll(f.getAllFiles());
        }
        return all;
    }

    @Override
    public List<CtFile> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<CtFile>();
            for (File f : this.file.listFiles()) {
                if (!FileFactory.isFile(f)) continue;
                this.files.add(new CtFileFile(f));
            }
        }
        return this.files;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public CtFolder getParent() {
        try {
            return FileFactory.createFolder(this.file.getParentFile());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<CtFolder> getSubFolder() {
        if (this.subFolders == null) {
            this.subFolders = new ArrayList<CtFolder>();
            for (File f : this.file.listFiles()) {
                if (FileFactory.isFile(f)) continue;
                try {
                    this.subFolders.add(FileFactory.createFolder(f));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.subFolders;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public List<CtFile> getAllJavaFiles() {
        ArrayList<CtFile> files = new ArrayList<CtFile>();
        for (CtFile f : this.getFiles()) {
            if (!f.isJava()) continue;
            files.add(f);
        }
        for (CtFolder fol : this.getSubFolder()) {
            files.addAll(fol.getAllJavaFiles());
        }
        return files;
    }

    @Override
    public String getPath() {
        return this.toString();
    }
}

