/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.processing;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import spoon.processing.ProcessorProperties;
import spoon.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlProcessorProperties
implements ProcessorProperties {
    Factory factory;
    String processorName;
    private Map<String, Object> props = new TreeMap<String, Object>();

    public XmlProcessorProperties(Factory factory, String processorName) {
        this.processorName = processorName;
        this.factory = factory;
    }

    public XmlProcessorProperties(Factory factory, String processorName, InputStream stream) throws IOException, SAXException {
        this.processorName = processorName;
        this.factory = factory;
        this.load(stream);
    }

    public void addProperty(String name, Object value) {
        this.props.put(name, value);
    }

    @Override
    public <T> T get(Class<T> type, String name) {
        if (!this.props.containsKey(name)) {
            return null;
        }
        if (type.isArray()) {
            return (T)this.factory.convertArray(type.getComponentType(), (Collection)this.props.get(name));
        }
        return this.factory.convert(type, this.props.get(name));
    }

    @Override
    public String getProcessorName() {
        return this.processorName;
    }

    private void load(InputStream stream) throws IOException, SAXException {
        if (stream == null) {
            return;
        }
        XMLReader xr = XMLReaderFactory.createXMLReader();
        Loader handler = new Loader();
        xr.setContentHandler(handler);
        xr.parse(new InputSource(stream));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Properties : \n");
        for (Map.Entry<String, Object> ent : this.props.entrySet()) {
            buf.append(ent.getKey());
            for (int i = ent.getKey().length(); i < 15; ++i) {
                buf.append(" ");
            }
            buf.append(": " + ent.getValue() + "\n");
        }
        return buf.toString();
    }

    public class Loader
    extends DefaultHandler {
        boolean isValue = false;
        String name;
        Object value;

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isValue) {
                if (this.value == null || !(this.value instanceof Collection)) {
                    this.value = new ArrayList();
                }
                ((Collection)this.value).add(new String(ch, start, length));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("property")) {
                XmlProcessorProperties.this.props.put(this.name, this.value);
                this.value = null;
            } else if (localName.equals("value")) {
                this.isValue = false;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("property")) {
                this.name = attributes.getValue("name");
                if (attributes.getValue("value") != null) {
                    this.value = attributes.getValue("value");
                }
            } else if (localName.equals("value")) {
                this.isValue = true;
            }
        }
    }
}

