/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.template;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.support.template.UndefinedParameterException;
import spoon.support.util.RtHelper;
import spoon.template.Parameter;
import spoon.template.Template;
import spoon.template.TemplateParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parameters {
    protected static final String fieldPrefix = "_FIELD_";
    static Map<Template, Map<String, Object>> finals = new HashMap<Template, Map<String, Object>>();

    private Parameters() {
    }

    public static Integer getIndex(CtExpression e) {
        if (e.getParent() instanceof CtArrayAccess) {
            CtExpression<Integer> indexExpression = ((CtArrayAccess)e.getParent()).getIndexExpression();
            return (Integer)((CtLiteral)indexExpression).getValue();
        }
        return null;
    }

    public static Object getValue(Template template, String parameterName, Integer index) {
        Object tparamValue = null;
        try {
            Field rtField = null;
            for (Field f : RtHelper.getAllFields(template.getClass())) {
                if (!Parameters.isParameterSource(f) || !parameterName.equals(Parameters.getParameterName(f))) continue;
                rtField = f;
                break;
            }
            if (Modifier.isFinal(rtField.getModifiers())) {
                Map<String, Object> m = finals.get(template);
                if (m == null) {
                    return null;
                }
                return m.get(parameterName);
            }
            rtField.setAccessible(true);
            tparamValue = rtField.get(template);
            if (rtField.getType().isArray() && index != null) {
                tparamValue = ((Object[])tparamValue)[index];
            }
        }
        catch (Exception e) {
            throw new UndefinedParameterException();
        }
        return tparamValue;
    }

    public static CtField getParameterField(CtClass<? extends Template> templateClass, String parameterName) {
        for (CtField<?> f : templateClass.getFields()) {
            Parameter p = f.getAnnotation(Parameter.class);
            if (p == null) continue;
            if (f.getSimpleName().equals(parameterName)) {
                return f;
            }
            if (!parameterName.equals(p.value())) continue;
            return f;
        }
        return null;
    }

    public static void setValue(Template template, String parameterName, Integer index, Object value) {
        Object tparamValue = null;
        try {
            Field rtField = null;
            for (Field f : RtHelper.getAllFields(template.getClass())) {
                if (!Parameters.isParameterSource(f) || !parameterName.equals(Parameters.getParameterName(f))) continue;
                rtField = f;
                break;
            }
            if (rtField == null) {
                return;
            }
            if (Modifier.isFinal(rtField.getModifiers())) {
                Map<String, Object> m = finals.get(template);
                if (m == null) {
                    m = new HashMap<String, Object>();
                    finals.put(template, m);
                }
                m.put(parameterName, value);
                return;
            }
            rtField.setAccessible(true);
            rtField.set(template, value);
            if (rtField.getType().isArray()) {
                tparamValue = ((Object[])tparamValue)[index];
            }
        }
        catch (Exception e) {
            throw new UndefinedParameterException();
        }
    }

    private static String getParameterName(Field f) {
        String name = f.getName();
        Parameter p = f.getAnnotation(Parameter.class);
        if (p != null && !p.value().equals("")) {
            name = p.value();
        }
        return name;
    }

    private static String getParameterName(CtFieldReference f) {
        String name = f.getSimpleName();
        Parameter p = f.getAnnotation(Parameter.class);
        if (p != null && !p.value().equals("")) {
            name = p.value();
        }
        return name;
    }

    public static Collection<String> getNames(CtClass<? extends Template> templateType) {
        ArrayList<String> params = new ArrayList<String>();
        try {
            for (CtFieldReference f : templateType.getReference().getAllFields()) {
                if (!Parameters.isParameterSource(f)) continue;
                params.add(Parameters.getParameterName(f));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static boolean isParameterSource(CtFieldReference<?> ref) {
        return ref.getAnnotation(Parameter.class) != null || !(ref.getType() instanceof CtTypeParameterReference) && !ref.getSimpleName().equals("this") && TemplateParameter.class.isAssignableFrom(ref.getType().getActualClass());
    }

    public static boolean isParameterSource(Field field) {
        return field.getAnnotation(Parameter.class) != null || TemplateParameter.class.isAssignableFrom(field.getType());
    }

    public static <T> TemplateParameter<T> NIL(Class<? extends T> type) {
        if (Number.class.isAssignableFrom(type)) {
            return new TemplateParameter<Number>(){

                @Override
                public CtCodeElement getSubstitution(CtSimpleType targetType) {
                    return null;
                }

                @Override
                public Number S() {
                    return 0;
                }
            };
        }
        return new TemplateParameter<T>(){

            @Override
            public CtCodeElement getSubstitution(CtSimpleType targetType) {
                return null;
            }

            @Override
            public T S() {
                return null;
            }
        };
    }
}

