/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.util.Util;

public class BasicCompilationUnit
implements ICompilationUnit {
    protected char[] contents;
    protected char[] fileName;
    protected char[][] packageName;
    protected char[] mainTypeName;
    protected String encoding;

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName) {
        this.contents = contents;
        this.fileName = fileName.toCharArray();
        this.packageName = packageName;
    }

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName, String encoding) {
        this(contents, packageName, fileName);
        this.encoding = encoding;
    }

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName, IJavaElement javaElement) {
        this(contents, packageName, fileName);
    }

    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent((File)new File(new String(this.fileName)), (String)this.encoding);
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR;
        }
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public char[] getMainTypeName() {
        if (this.mainTypeName == null) {
            int end;
            int separator;
            int start = CharOperation.lastIndexOf((char)'/', (char[])this.fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf((char)'\\', (char[])this.fileName)) {
                start = CharOperation.lastIndexOf((char)'\\', (char[])this.fileName) + 1;
            }
            if ((separator = CharOperation.indexOf((char)'|', (char[])this.fileName) + 1) > start) {
                start = separator;
            }
            if (!((end = CharOperation.lastIndexOf((char)'$', (char[])this.fileName)) != -1 && Util.isClassFileName((char[])this.fileName) || (end = CharOperation.lastIndexOf((char)'.', (char[])this.fileName)) != -1)) {
                end = this.fileName.length;
            }
            this.mainTypeName = CharOperation.subarray((char[])this.fileName, (int)start, (int)end);
        }
        return this.mainTypeName;
    }

    public char[][] getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "CompilationUnit: " + new String(this.fileName);
    }
}

