/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.compiler.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileUtil {
    static int u2(byte[] bytes, int offset) {
        int i = 0;
        i |= bytes[offset] & 0xFF;
        i <<= 8;
        return i |= bytes[offset + 1] & 0xFF;
    }

    static long u4(byte[] bytes, int offset) {
        long l = 0L;
        l |= (long)(bytes[offset] & 0xFF);
        l <<= 8;
        l |= (long)(bytes[offset + 1] & 0xFF);
        l <<= 8;
        l |= (long)(bytes[offset + 2] & 0xFF);
        l <<= 8;
        return l |= (long)(bytes[offset + 3] & 0xFF);
    }

    public static void printBytes(byte[] bytes, int offset) {
        for (int i = offset; i < bytes.length; ++i) {
            System.out.print("(" + i + "):" + bytes[i]);
        }
        System.out.println();
    }

    public static void adjustLineNumbers(byte[] bytes, int methodsOffset, Map<Integer, Integer> lineNumberMapping) {
        if (lineNumberMapping == null) {
            return;
        }
        int offset = methodsOffset + 2;
        int methodCount = ClassFileUtil.u2(bytes, methodsOffset);
        for (int i = 0; i < methodCount; ++i) {
            offset = ClassFileUtil.adjustMethod(bytes, offset, lineNumberMapping);
        }
    }

    static int adjustMethod(byte[] bytes, int offset, Map<Integer, Integer> lineNumberMapping) {
        int attrCount = ClassFileUtil.u2(bytes, offset + 6);
        offset += 8;
        for (int i = 0; i < attrCount; ++i) {
            offset = ClassFileUtil.adjustCodeAttribute(bytes, offset, lineNumberMapping);
        }
        return offset;
    }

    static int adjustCodeAttribute(byte[] bytes, int offset, Map<Integer, Integer> lineNumberMapping) {
        String attrName = ClassFileUtil.getPoolString(bytes, ClassFileUtil.u2(bytes, offset));
        if ("Code".equals(attrName)) {
            int offset2 = offset + 14 + (int)ClassFileUtil.u4(bytes, offset + 10);
            offset2 += ClassFileUtil.u2(bytes, offset2) * 8;
            int attrCount = ClassFileUtil.u2(bytes, offset2 += 2);
            offset2 += 2;
            for (int i = 0; i < attrCount; ++i) {
                offset2 = ClassFileUtil.adjustLineNumberAttribute(bytes, offset2, lineNumberMapping);
            }
        }
        return offset + 6 + (int)ClassFileUtil.u4(bytes, offset + 2);
    }

    static int adjustLineNumberAttribute(byte[] bytes, int offset, Map<Integer, Integer> lineNumberMapping) {
        String attrName = ClassFileUtil.getPoolString(bytes, ClassFileUtil.u2(bytes, offset));
        if ("LineNumberTable".equals(attrName)) {
            int offset2 = offset + 6;
            int lineCount = ClassFileUtil.u2(bytes, offset2);
            offset2 += 2;
            for (int i = 0; i < lineCount; ++i) {
                int org = ClassFileUtil.u2(bytes, offset2 + 2);
                Integer pos = lineNumberMapping.get(org);
                if (pos != null) {
                    int ipos = pos;
                    bytes[offset2 + 2] = (byte)(ipos >> 8);
                    bytes[offset2 + 3] = (byte)ipos;
                }
                offset2 += 4;
            }
        }
        return offset + 6 + (int)ClassFileUtil.u4(bytes, offset + 2);
    }

    static String getPoolString(byte[] bytes, int index) {
        int offset = 10;
        for (int i = index; i > 1; --i) {
            if (bytes[offset] == 6 || bytes[offset] == 5) {
                --i;
            }
            offset = ClassFileUtil.skipPoolConstant(bytes, offset);
        }
        if (bytes[offset] != 1) {
            throw new RuntimeException("error in pool constant: unable to get utf8 at " + index + " (o=" + offset + ")");
        }
        int length = ClassFileUtil.u2(bytes, offset + 1);
        byte[] string = new byte[length];
        try {
            System.arraycopy(bytes, offset + 3, string, 0, length);
        }
        catch (Exception e) {
            System.err.println("error getting the string: l=" + length + ", o=" + offset);
            ClassFileUtil.printBytes(bytes, offset + 3);
            e.printStackTrace();
        }
        return new String(string);
    }

    static int skipPoolConstant(byte[] bytes, int offset) {
        byte constantType = bytes[offset];
        switch (constantType) {
            case 7: 
            case 8: {
                return offset + 3;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return offset + 5;
            }
            case 5: 
            case 6: {
                return offset + 9;
            }
            case 1: {
                return offset + 3 + ClassFileUtil.u2(bytes, offset + 1);
            }
        }
        throw new RuntimeException("invalid constant pool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToDisk(boolean generatePackagesStructure, String outputPath, String relativeFileName, byte[] bytes) throws IOException {
        BufferedOutputStream output = null;
        if (generatePackagesStructure) {
            output = new BufferedOutputStream(new FileOutputStream(new File(ClassFileUtil.buildAllDirectoriesInto(outputPath, relativeFileName))));
        } else {
            String fileName = null;
            char fileSeparatorChar = File.separatorChar;
            String fileSeparator = File.separator;
            outputPath = outputPath.replace('/', fileSeparatorChar);
            int indexOfPackageSeparator = relativeFileName.lastIndexOf(fileSeparatorChar);
            if (indexOfPackageSeparator == -1) {
                fileName = outputPath.endsWith(fileSeparator) ? outputPath + relativeFileName : outputPath + fileSeparator + relativeFileName;
            } else {
                int length = relativeFileName.length();
                fileName = outputPath.endsWith(fileSeparator) ? outputPath + relativeFileName.substring(indexOfPackageSeparator + 1, length) : outputPath + fileSeparator + relativeFileName.substring(indexOfPackageSeparator + 1, length);
            }
            output = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
        }
        try {
            output.write(bytes, 0, bytes.length);
        }
        finally {
            output.flush();
            output.close();
        }
    }

    static String buildAllDirectoriesInto(String outputPath, String relativeFileName) throws IOException {
        File f;
        char fileSeparatorChar = File.separatorChar;
        String fileSeparator = File.separator;
        if ((outputPath = outputPath.replace('/', fileSeparatorChar)).endsWith(fileSeparator)) {
            outputPath = outputPath.substring(0, outputPath.length() - 1);
        }
        if ((f = new File(outputPath)).exists()) {
            if (!f.isDirectory()) {
                String message = Messages.bind((String)Messages.output_isFile, (Object)f.getAbsolutePath());
                throw new IOException(message);
            }
        } else if (!f.mkdirs()) {
            String message = Messages.bind((String)Messages.output_notValidAll, (Object)f.getAbsolutePath());
            throw new IOException(message);
        }
        StringBuffer outDir = new StringBuffer(outputPath);
        outDir.append(fileSeparator);
        StringTokenizer tokenizer = new StringTokenizer(relativeFileName, fileSeparator);
        String token = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            f = new File(outDir.append(token).append(fileSeparator).toString());
            if (!f.exists() && !f.mkdir()) {
                throw new IOException(Messages.bind((String)Messages.output_notValid, (Object)f.getName()));
            }
            token = tokenizer.nextToken();
        }
        return outDir.append(token).toString();
    }
}

