/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import spoon.support.util.BasicCompilationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTCompiler
implements ICompilerRequestor {
    CompilerOptions compilerOption;
    List<ClassFile> classFiles = new ArrayList<ClassFile>();

    public static ICompilationUnit getUnit(String name, File file) throws Exception {
        int read;
        String[] tmp = name.split("[.]");
        char[][] pack = new char[tmp.length - 1][];
        for (int i = 0; i < tmp.length - 1; ++i) {
            pack[i] = tmp[i].toCharArray();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[512];
        while ((read = in.read(buffer, 0, 512)) >= 0) {
            out.write(buffer, 0, read);
        }
        BasicCompilationUnit unit = null;
        unit = new BasicCompilationUnit(out.toString().toCharArray(), pack, file.getName());
        out.close();
        in.close();
        return unit;
    }

    public void acceptResult(CompilationResult result) {
        if (result.hasErrors()) {
            System.err.println(result);
        }
        for (ClassFile f : result.getClassFiles()) {
            this.classFiles.add(f);
        }
    }

    public List<ClassFile> compile(ICompilationUnit[] units) {
        Compiler compiler = new Compiler((INameEnvironment)this.getLibraryAccess(), this.getHandlingPolicy(), this.getCompilerOption(), (ICompilerRequestor)this, (IProblemFactory)new DefaultProblemFactory());
        compiler.compile(units);
        return this.classFiles;
    }

    public CompilerOptions getCompilerOption() {
        if (this.compilerOption == null) {
            this.compilerOption = new CompilerOptions();
            this.compilerOption.sourceLevel = 0x310000L;
            this.compilerOption.suppressWarnings = true;
        }
        return this.compilerOption;
    }

    private IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    FileSystem getLibraryAccess() {
        File f;
        String bootpath = System.getProperty("sun.boot.class.path");
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> lst = new ArrayList<String>();
        for (String s : bootpath.split(File.pathSeparator)) {
            f = new File(s);
            if (!f.exists()) continue;
            lst.add(f.getAbsolutePath());
        }
        for (String s : classpath.split(File.pathSeparator)) {
            f = new File(s);
            if (!f.exists()) continue;
            lst.add(f.getAbsolutePath());
        }
        return new FileSystem(lst.toArray(new String[0]), new String[0], System.getProperty("file.encoding"));
    }

    public List<ClassFile> getClassFiles() {
        return this.classFiles;
    }
}

