/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import spoon.processing.Processor;
import spoon.processing.TraversalStrategy;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingVisitor
extends CtScanner {
    Factory factory;
    Processor processor;

    public ProcessingVisitor(Factory factory) {
        this.factory = factory;
    }

    private boolean canBeProcessed(Processor p, CtElement e) {
        if (!this.factory.getEnvironment().isProcessingStopped() && p.getProcessedElementTypes() != null) {
            for (Class<CtElement> o : p.getProcessedElementTypes()) {
                if (!o.isAssignableFrom(e.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void scan(Collection<? extends CtElement> elements) {
        if (elements != null) {
            for (CtElement ctElement : new ArrayList<CtElement>(elements)) {
                this.scan(ctElement);
            }
        }
    }

    @Override
    public void scan(CtElement e) {
        if (e == null) {
            return;
        }
        if (this.processor.getTraversalStrategy() == TraversalStrategy.PRE_ORDER && this.canBeProcessed(this.processor, e) && this.processor.isToBeProcessed(e)) {
            this.processor.process(e);
        }
        try {
            super.scan(e);
        }
        catch (ConcurrentModificationException e1) {
            this.scan(e);
        }
        if (this.processor.getTraversalStrategy() == TraversalStrategy.POST_ORDER && this.canBeProcessed(this.processor, e) && this.processor.isToBeProcessed(e)) {
            this.processor.process(e);
        }
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }
}

