/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.io;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeClassLoader;

public class NodeOutputStream {
    protected static final byte NULL_REF = 16;
    protected static final byte NEW_NODE = 17;
    protected static final byte NODE_REF = 18;
    protected static final byte OBJ_DECO = 32;
    protected static final byte NODE_DECO = 33;
    protected static final byte END_OF_DECO = 34;
    protected static final byte NEW_CLASS = 112;
    protected static final byte CLASS_REF = 113;
    protected final ObjectOutputStream out;
    protected final Map<Node, Integer> nodeIds = new IdentityHashMap<Node, Integer>();
    protected final Map<Class<? extends Node>, Integer> nodeClassIds = new IdentityHashMap<Class<? extends Node>, Integer>();

    public NodeOutputStream(ObjectOutputStream out) throws IOException {
        this.out = out;
        out.reset();
    }

    public NodeOutputStream(OutputStream out) throws IOException {
        if (out instanceof ObjectOutputStream) {
            this.out = (ObjectOutputStream)out;
            this.out.reset();
        } else {
            this.out = new ObjectOutputStream(out);
            this.out.flush();
        }
    }

    public synchronized void reset() throws IOException {
        this.nodeClassIds.clear();
        this.out.reset();
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.reset();
        this.out.close();
    }

    public synchronized void writeNode(Node node) throws IOException {
        if (node == null) {
            this.out.writeByte(16);
            return;
        }
        Integer id = this.nodeIds.get(node);
        if (id == null) {
            id = this.nodeIds.size();
            this.nodeIds.put(node, id);
            this.out.writeByte(17);
            this.writeNodeClass(node);
            this.writeNodeData(node);
        } else {
            this.out.writeByte(18);
            this.out.writeInt(id);
        }
    }

    protected void writeNodeClass(Node node) throws IOException {
        Class<?> nodeClass = node.getClass();
        Integer id = this.nodeClassIds.get(nodeClass);
        if (id == null) {
            id = this.nodeClassIds.size();
            this.nodeClassIds.put(nodeClass, id);
            this.out.writeByte(112);
            byte[] byteCode = ((NodeClassLoader)nodeClass.getClassLoader()).getClassBytecode(node);
            this.out.writeInt(byteCode.length);
            this.out.write(byteCode);
        } else {
            this.out.writeByte(113);
            this.out.writeInt(id);
        }
    }

    protected void writeNodeData(Node node) throws IOException {
        Node[] subNodes;
        this.out.writeObject(node.astGetSource());
        Map<String, String> attributes = node.astGetAttributes();
        this.out.writeInt(attributes.size());
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            this.out.writeUTF(attribute.getKey());
            this.out.writeObject(attribute.getValue());
        }
        for (Map.Entry<String, Object> decoration : node.astGetDecorations().entrySet()) {
            Object deco = decoration.getValue();
            if (deco == null || deco instanceof Serializable) {
                this.out.writeByte(32);
                this.out.writeUTF(decoration.getKey());
                this.out.writeObject(deco);
                continue;
            }
            if (!(deco instanceof Node)) continue;
            this.out.writeByte(33);
            this.out.writeUTF(decoration.getKey());
            this.writeNode((Node)deco);
        }
        this.out.writeByte(34);
        int nbSubNode = 0;
        for (String nodeType : node.astGetNodeTypes()) {
            subNodes = node.astGetNodes(nodeType);
            if (subNodes == null) continue;
            for (Node subNode : subNodes) {
                if (subNode == null) continue;
                ++nbSubNode;
            }
        }
        this.out.writeInt(nbSubNode);
        for (String nodeType : node.astGetNodeTypes()) {
            subNodes = node.astGetNodes(nodeType);
            if (subNodes == null) continue;
            for (Node subNode : subNodes) {
                if (subNode == null) continue;
                this.writeNode(subNode);
            }
        }
    }
}

